/* #------------------------------------------------------------------------#
   |                                                                        |
   |   makebin.c                                                            |
   |                                                                        |
   |   Make binary form hex.                                                |
   |                                                                        |
   |   Copyright 2001, Frank A. Vorstenbosch                                |
   |                                                                        |
   #------------------------------------------------------------------------# */

/* $Id: makebin.c,v 0.3 2001/12/22 12:19:50 frank Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define VERSION 0x00000

FILE *hexFile,*relFile,*outFile;

char line[100];

int UnHexDigit(char *p)
{
   if(*p>='0' && *p<='9')
      return *p-'0';
   if(*p>='a' && *p<='f')
      return *p-'a'+10;
   if(*p>='A' && *p<='F')
      return *p-'A'+10;
   return -1;
}

int UnHexByte(char *p)
{  
   return UnHexDigit(p)*16+UnHexDigit(p+1);
}

int UnHexWord(char *p)
{  
   return UnHexByte(p)*256+UnHexByte(p+2);
}

/* -------------------------------------------------------------------------- */

int main(int argc,char *argv[])
{  int i,n,mode,verbose=0;
   char *p;
   long address=0,na,val;

   if(argc<4)
   {  printf("Usage MAKEBIN outfile hexfile relfile [-v]\n");
      return 1; }

   if(argv[4] && !strcmp(argv[4],"-v"))
      verbose=1;

   if((hexFile=fopen(argv[2],"r"))==NULL)
      return 2;
   if((outFile=fopen(argv[1],"wb+"))==NULL)
      return 2;

   if(verbose)
      printf("Decoding hex file.\n");

   while(fgets(line,100,hexFile))
   {
      if(line[0]!='S' || line[1]!='3')
         continue;

      n=UnHexByte(line+2);
      na=((UnHexWord(line+4)&0xffffL)<<16L)+(UnHexWord(line+8)&0xffffL);

      if(na<address)
      {  printf("Negative move tried at address %lx\nThe source line was: \"%s\"\n",na,line);
         return 3; }

      while(address<na)
      {  putc(0,outFile);
         address++; }

      for(i=0;i<n-5;i++)
      {  putc(UnHexByte(line+12+2*i),outFile);
         address++; }
   }

   if(verbose)
      printf("Reading relocation info.\n");

   if((relFile=fopen(argv[3],"r"))==NULL)
      return 2;

   mode=0;
   while(fgets(line,100,relFile))
   {  p=line+strlen(line);
      
      while(p>line)
      {  p--;
         if(*p=='\n')
            *p=0;
         else
            break; }

      if(!mode && strstr(line,"Relocation entries for section \".text"))
         mode=1;

      if(!*line || strstr(line,"Dump of") || strstr(line,"Relocation") || strstr(line,"MetaWare") || strstr(line,"Addend") || strstr(line,"---"))
         continue;

      if(verbose)
         printf("reloc line=\"%s\"\n",line);

      address=na=-1;
      if(sscanf(line,"%li %i %*s %li",&address,&i,&na)==3 || i!=12 || address<0 || na<0)
      {  
         if(verbose)
            printf("address=%lx ",address);

         fseek(outFile,address,SEEK_SET);
         fread(&val,4,1,outFile);
         
         if(verbose)
            printf("value=%lx->",val);

         val+=na;
         if(verbose)
            printf("%lx ",val);

         fseek(outFile,address,SEEK_SET);
         fwrite(&val,4,1,outFile);

         if(verbose)
            printf("mode=%d\n",mode);
         
         if(mode)
         {  fseek(outFile,0,SEEK_END);
            fwrite(&address,4,1,outFile); }
      }
      else
         printf("ignored this line: \"%s\"\n",line);
   }

   fclose(relFile);
   fseek(outFile,0,SEEK_END);
   address=-1;
   fwrite(&address,4,1,outFile);

   return 0;
}

/* ----- EOF makebin.c ----- */

