REM NWClient front end, supplies disc icons, login prompts, etc.
REM ---------------------------------------------------------------------

DEBUG=0

REM ----- run old version if needed -------------------------------------

ON ERROR ON ERROR OFF:ERROR 1,REPORT$+" (internal code "+STR$ERRL+"/"+STR$ERRN+")."
IF DEBUG THEN SYS "XOS_SWINumberFromString",,"XTrace_Write0" TO DEBUG;V:IF V AND 1 THEN DEBUG=0
SYS "XOS_SWINumberFromString",,"NWClient_Login" TO r0;V
IF (V AND 1)=0 THEN SYS r0 OR &2003f,0 TO r0;V
IF (V AND 1)<>0 OR r0<162 OR r0>999 THEN OSCLI("filer_run <NWLogin$Dir>.^.!OldLog"):END

END=90<<10

NCP_CONN_NOT_LOGGED_IN=-125

MAX_ICONS   = 16
MAX_SERVERS = 16

DIM sprname% 64
DIM block% 1024
DIM menu% 1024

DIM Icons%(MAX_ICONS),IconMode(MAX_ICONS)
DIM IconMount%(MAX_ICONS),IconServer%(MAX_ICONS),IconName$(MAX_ICONS,3)
DIM IconLabel% MAX_ICONS*16

REM ---------------------------------------------------------------------

SYS "Wimp_Initialise",200,&4B534154,"NWClient-kill"
r0=0
REPEAT
   SYS "TaskManager_EnumerateTasks",r0,block%,20 TO r0
   IF r0>=0 THEN
      IF DEBUG THEN SYS DEBUG,CHR$10+"found task "+STR$~(block%!4)
      IF block%!4 THEN SYS "XOS_GenerateError",block%!4 TO name$ ELSE name$=""
      IF DEBUG THEN SYS DEBUG,"="+CHR$34+name$+CHR$34
      IF name$="NWClient" THEN
         task%=block%!0
         block%!0=20
         block%!12=0
         block%!16=0
         SYS "Wimp_SendMessage",17,block%,task%
         FOR I%=1 TO 100
            SYS "Wimp_Poll",0,block% TO A%:IF A%=0 THEN I%+=33
         NEXT
      ENDIF
   ENDIF
UNTIL r0<0
SYS "Wimp_CloseDown"

REM ---------------------------------------------------------------------

SYS "Wimp_Initialise",200,&4B534154,"NWClient"
ON ERROR PROCerror

SYS "XOS_SWINumberFromString",,"NWClient_Login" TO ;V
IF V AND 1 THEN
   !block%=0:$(block%+4)="NWClient module not loaded."+CHR$0
   SYS "Wimp_ReportError",block%,1,"NWClient"
   SYS "Wimp_CloseDown"
   END
ENDIF

PROCsetup
PROCmakeicons

REM ----- main loop -----------------------------------------------------

quit%=FALSE
rmkill%=FALSE
poll%=10:pollct%=25
REPEAT
   SYS "OS_ReadMonotonicTime" TO time%
   SYS "Wimp_PollIdle",0,block%,time%+poll% TO A%
   IF DEBUG THEN SYS DEBUG,CHR$10+CHR$10+"poll="+STR$A%
   CASE A% OF
   
      WHEN 0:REM null
         PROCmakeicons
         IF pollct%=0 THEN poll%=1000 ELSE pollct%-=1
         
      WHEN 2:REM open window request
         SYS "Wimp_OpenWindow",,block%
         
      WHEN 3:REM close window requst
         SYS "Wimp_CreateMenu",,-1
         SYS "Wimp_CloseWindow",,block%
         
      WHEN 6:REM mouse click
         IF block%!12=-2 THEN
            PROCmouseclick(block%!0,block%!8,block%!16)
         ELSE
            IF block%!8=4 THEN
               REM mouse click on some icon in one of our windows
               CASE block%!12 OF
                  WHEN mountHandle%: PROCmountclick(block%!16)
                  WHEN loginHandle%: PROCloginclick(block%!16)
                  WHEN attachHandle%:PROCattachclick(block%!16)
                  WHEN detachHandle%:PROCdetachclick(block%!16)
               ENDCASE
            ENDIF
         ENDIF
         
      WHEN 8:REM key pressed
         CASE block%!0 OF
            WHEN mountHandle%:PROCmountkey(block%!4,block%!24)
            WHEN loginHandle%:PROCloginkey(block%!4,block%!24)
            WHEN attachHandle%:PROCattachkey(block%!4,block%!24)
            WHEN detachHandle%:PROCdetachkey(block%!4,block%!24)
         ENDCASE
         
      WHEN 9:REM menu selection
         PROCdecodemenu(block%)
         
      WHEN 17,18:REM user message
         IF block%!16=0 THEN quit%=TRUE
   ENDCASE
   REM PROCmakeicons : REM refresh the display
UNTIL quit%

SYS "Wimp_CloseDown"
IF rmkill% THEN SYS "XOS_Module",4,"NWClient":SYS "XOS_Module",4,"RiscIPX"

END

REM ---------------------------------------------------------------------

DEF PROCmouseclick(xpos%,button%,handle%)
   LOCAL j
   
   IF DEBUG THEN SYS DEBUG,CHR$10+"mouseclick("+STR$(xpos%)+","+STR$(button%)+","+STR$(handle%)+") "

   Icon%=-1
   FOR j=0 TO MAX_ICONS-1
      IF Icons%(j)=handle% THEN Icon%=j
   NEXT
   
   CASE button% OF
      WHEN 4:REM select button
         CASE IconMode(Icon%) OF
            WHEN 0:REM nothing  - open attach window
               PROCattachwindow
            WHEN 1:REM attached - open login window
               PROCloginwindow(Icon%)
            WHEN 2:REM logged   - open mount window
               $(!(mountTpl%+88+2*32+20))=""
               $(!(mountTpl%+88+3*32+20))=IconName$(Icon%,2)+"/SYS:"
               PROCmountwindow(Icon%)
            WHEN 3:REM mounted  - open directory
               OSCLI("filer_opendir nw::"+IconName$(Icon%,1)+".$")
         ENDCASE

      WHEN 1:REM adjust button
         CASE IconMode(Icon%) OF
            WHEN 0:REM nothing  - try attaching to anything at all
               SYS "XNWClient_Attach",0,0 TO ;V
               IF (V AND 1)=0 THEN
                  PROCmakeicons
               ENDIF
            WHEN 1:REM attached - detach
               PROCdetach(Icon%)
            WHEN 2:REM logged   - logout
               PROClogout(Icon%)
            WHEN 3:REM mounted  - show free space
               OSCLI("showfree -FS NW "+IconName$(Icon%,1))
         ENDCASE

      WHEN 2:REM menu button
         j=FNinitmenu(IconMode(Icon%))
         CASE IconMode(Icon%) OF
            WHEN 0:REM nothing
            WHEN 1:REM attached
            WHEN 2:REM logged
               $(!(mountTpl%+88+2*32+20))=""
               $(!(mountTpl%+88+3*32+20))=IconName$(Icon%,2)+"/"
            WHEN 3:REM mounted
               $(!(mountTpl%+88+2*32+20))=IconName$(Icon%,1)
               $(!(mountTpl%+88+3*32+20))=IconName$(Icon%,2)
         ENDCASE
         SYS"Wimp_CreateMenu",,menu%,xpos%-64,96+j*44

   ENDCASE
ENDPROC

REM ---------------------------------------------------------------------

DEF PROCdecodemenu(b%)
   LOCAL stay%,item$,i,j

   IF DEBUG THEN SYS DEBUG,CHR$10+"decodemenu("+STR$(b%)+") "

   i=-1
   FOR j=0 TO MAX_ICONS-1
      IF Icons%(j)=b%!16 THEN i=j
   NEXT
   IF i>=0 THEN

      item$=STRING$(255," ")
      SYS "Wimp_DecodeMenu",,menu%,b%,item$ TO ,,,item$

      SYS "Wimp_GetPointerInfo",,b%
      stay%=(b%!8=1)

      CASE item$ OF
         WHEN "Info":    REM nothing
         WHEN "Attach":
         WHEN "Detach":  PROCdetach(i)
         WHEN "Mount":   PROCmountwindow(i)
         WHEN "Dismount":PROCdismount(i)
         WHEN "Login":   PROCloginwindow(i)
         WHEN "Logout":  PROClogout(i)
         WHEN "Free":    PROCfree(i)
         WHEN "Quit":    rmkill%=TRUE:quit%=TRUE:stay%=FALSE
      ENDCASE

      IF stay% THEN SYS"Wimp_CreateMenu",,menu%,b%!0,b%!4
   ENDIF

ENDPROC


REM +-------------------------------------------------------------------+
REM |                                                                   |
REM |   Mount menu handling.                                            |
REM |                                                                   |
REM +-------------------------------------------------------------------+

REM Icon numbers for Mount template
REM    0 - OK
REM    1 - Cancel
REM    2 - Local name
REM    3 - Remote name
REM    4 - No icon
REM    5 - No long file names

DEF PROCmountclick(i%)
   IF DEBUG THEN SYS DEBUG,CHR$10+"mountclick("+STR$(i%)+") "

   CASE i% OF
      WHEN 0:REM ok
         PROCdomount
      WHEN 1:REM cancel
         PROCclosemount
      WHEN 4,5:
         block%!0=mountHandle%
         block%!4=i%
         block%!8=1<<21
         block%!12=0
         SYS "Wimp_SetIconState",,block%
   ENDCASE
ENDPROC

REM ---------------------------------------------------------------------

DEF PROCclosemount
   IF DEBUG THEN SYS DEBUG,CHR$10+"closemount() "
   SYS "Wimp_CreateMenu",,-1
   block%!0=mountHandle%
   SYS "Wimp_CloseWindow",,block%
ENDPROC

REM ---------------------------------------------------------------------

DEF PROCdomount
   LOCAL mt,local$,remote$,flags
   IF DEBUG THEN SYS DEBUG,CHR$10+"domount() "
   
   flags=0
   SYS &2002B,!(mountTpl%+88+2*32+20) TO local$
   SYS &2002B,!(mountTpl%+88+3*32+20) TO remote$

   block%!0=mountHandle%
   block%!4=4
   SYS "Wimp_GetIconState",,block%:IF (block%!24)AND(1<<21) THEN flags+=1

   block%!0=mountHandle%
   block%!4=5
   SYS "Wimp_GetIconState",,block%:IF (block%!24)AND(1<<21) THEN flags+=4

   SYS "XNWClient_Mount",local$,remote$,flags TO mt;V
   PROCclosemount
   IF V AND 1 THEN
      SYS &2002B,mt+4 TO local$
      $(block%+4)="Can't mount that directory.  Error: "+local$
      block%!0=0
      SYS "Wimp_ReportError",block%,1,"NWClient"
   ENDIF
ENDPROC

REM ---------------------------------------------------------------------

DEF PROCmountkey(i%,key%)
   LOCAL f$,len
   IF DEBUG THEN SYS DEBUG,CHR$10+"mountkey("+STR$(i%)+",",STR$(key%)+") "

   CASE key% OF
      WHEN 27:
         PROCclosemount
      WHEN 13:
         IF i%=3 THEN PROCdomount
   ENDCASE
ENDPROC

REM ---------------------------------------------------------------------

DEF PROCmountwindow(i%)
   LOCAL x,y,t,n$
   IF DEBUG THEN SYS DEBUG,CHR$10+"mountwindow("+STR$(i%)+") "

   SYS "OS_ReadModeVariable",-1,4 TO ,,t
   SYS "OS_ReadModeVariable",-1,11 TO ,,x:x=(x+1)<<t
   SYS "OS_ReadModeVariable",-1,5 TO ,,t
   SYS "OS_ReadModeVariable",-1,12 TO ,,y:y=(y+1)<<t

   Icon%=i%
   
   block%!0=mountHandle%
   SYS "Wimp_GetWindowInfo",,block%
   block%!12-=block%!4:block%!16-=block%!8
   block%!4=(x-block%!12)/2
   block%!8=(y-block%!16)/2
   block%!12+=block%!4:block%!16+=block%!8
   SYS "Wimp_OpenWindow",,block%
   SYS &2002B,!(mountTpl%+88+2*32+20) TO n$
   SYS "Wimp_SetCaretPosition",mountHandle%,2,-1,-1,-1,LEN(n$)
ENDPROC


REM +-------------------------------------------------------------------+
REM |                                                                   |
REM |   Dismount, logout and free space handling.                       |
REM |                                                                   |
REM +-------------------------------------------------------------------+

DEF PROCdismount(i%)
   LOCAL r0,V
   IF DEBUG THEN SYS DEBUG,CHR$10+"dismount("+STR$(i%)+") "
   
   IF IconMount%(i%) THEN
      SYS "XNWClient_Dismount",IconMount%(i%) TO r0;V
      IF (V AND 1)=0 THEN PROCmakeicons ELSE SYS "Wimp_ReportError",r0,1,"NWClient"
   ENDIF
ENDPROC

REM ---------------------------------------------------------------------

DEF PROClogout(i%)
   LOCAL r0,V,n$,fs%,sn%
   IF DEBUG THEN SYS DEBUG,CHR$10+"logout("+STR$(i%)+") fs="+STR$~(IconServer%(i%))
   
   fs%=0
   REPEAT   
      SYS "XNWClient_ServerList",fs% TO fs%,sn%;V
   UNTIL fs%=0 OR (V AND 1)<>0 OR fs%=IconServer%(i%)
   
   IF (V AND 1)=0 AND fs%<>0 THEN SYS &2002B,sn% TO n$:n$=n$+"/" ELSE n$=""
   SYS "XNWClient_Logout",IconServer%(i%) TO r0;V
   IF (V AND 1)=0 THEN
      SYS "XNWClient_Mount","Login",n$+"SYS:LOGIN",&81
      PROCmakeicons
   ELSE
      SYS "Wimp_ReportError",r0,1,"NWClient"
   ENDIF
ENDPROC


REM ---------------------------------------------------------------------

DEF PROCfree(i%)
   IF DEBUG THEN SYS DEBUG,CHR$10+"free("+STR$(i%)+") "
   IF IconMount%(i%) THEN
      OSCLI("showfree -FS NW "+IconName$(i%,1))
   ENDIF
ENDPROC


REM +-------------------------------------------------------------------+
REM |                                                                   |
REM |   Login menu handling.                                            |
REM |                                                                   |
REM +-------------------------------------------------------------------+

REM Icon numbers for Login template
REM    0 - OK
REM    1 - Cancel
REM    2 - User name
REM    3 - Password

DEF PROCloginclick(i%)
   LOCAL user$,pass$
   IF DEBUG THEN SYS DEBUG,CHR$10+"loginclick("+STR$(i%)+") "
   
   CASE i% OF
      WHEN 1:PROCcloselogin
      WHEN 0:PROCdologin
   ENDCASE
ENDPROC

REM ---------------------------------------------------------------------

DEF PROCcloselogin
   IF DEBUG THEN SYS DEBUG,CHR$10+"closelogin() "
   
   SYS "Wimp_CreateMenu",,-1
   block%!0=loginHandle%
   SYS "Wimp_CloseWindow",,block%
   logingetid=TRUE
ENDPROC

REM ---------------------------------------------------------------------

DEF PROCdologin
   LOCAL r0,localname,localname$,user$,pass$,h%,mt%,V,server%,exp
   IF DEBUG THEN SYS DEBUG,CHR$10+"dologin() Icon%="+STR$Icon%+"->"+IconName$(Icon%,2)
   
   SYS &2002B,!(loginTpl%+88+2*32+20) TO user$
   SYS &2002B,!(loginTpl%+88+3*32+20) TO pass$
   PROCcloselogin
   $(!(loginTpl%+88+2*32+20))="":$(!(loginTpl%+88+3*32+20))=""
   
   IF IconServer%(Icon%)=0 THEN SYS "XNWClient_Login",user$,pass$ TO r0;V ELSE SYS "XNWClient_Login",IconName$(Icon%,2)+"/"+user$,pass$ TO r0;V
   pass$=""
   exp=FALSE
   IF (V AND 1)<>0 AND (r0!0)=-&df THEN V=0:exp=TRUE
   IF V AND 1 THEN
      SYS "XOS_SetVarVal","NW$User",0,-1,0,4
      IF (r0!0)<>-255 THEN SYS &2002B,r0+4 TO user$ ELSE user$="Invalid username or password."
      $(block%+4)="Error logging in: "+user$
      block%!0=0
      SYS "Wimp_ReportError",block%,1,"NWClient"
   ELSE
      mt%=0:h%=FALSE
      REPEAT
         SYS "XNWClient_MountList",mt%,0,0,0,0,0 TO mt%,localname,,,,server%;V
         SYS &2002B,localname TO localname$
         IF FNlower(localname$)="login" AND server%=IconServer%(Icon%) THEN h%=TRUE
      UNTIL mt%=0 OR (V AND 1)<>0
   
      IF h% THEN
         h%=OPENIN"NW::Login.$.!Boot":IF h%=0 THEN h%=OPENIN"NW::Login.$.!Boot.!Boot"
         IF h% THEN
            CLOSE#h%
            SYS "OS_SetVarVal","NW$User",user$,LEN(user$),0,4
            SYS "OS_SetVarVal","NW$Server",IconName$(Icon%,2),LEN(IconName$(Icon%,2)),0,4
            OSCLI("wimptask run NW::Login.$.!Boot")
            SYS "XOS_SetVarVal","NW$User",0,-1,0,4
            SYS "XOS_SetVarVal","NW$Server",0,-1,0,4
         ENDIF
      ENDIF
   ENDIF
   poll%=10:pollct%=25
   IF exp THEN
      $(block%+4)="Your password has expired.  Please change the password now, otherwise you might not be able to log in again."
      block%!0=0
      SYS "Wimp_ReportError",block%,1,"NWClient"
   ENDIF
ENDPROC

REM ---------------------------------------------------------------------

DEF PROCloginkey(i%,key%)
   IF DEBUG THEN SYS DEBUG,CHR$10+"loginkey("+STR$(i%)+",",STR$(key%)+") "
   
   CASE key% OF
      WHEN 27:
         PROCcloselogin
      WHEN 13:
         IF i%=3 THEN PROCdologin
   ENDCASE
ENDPROC

REM ---------------------------------------------------------------------

DEF PROCloginwindow(i%)
   LOCAL x,y,t,n$
   IF DEBUG THEN SYS DEBUG,CHR$10+"loginwindow("+STR$(i%)+") "

   SYS "OS_ReadModeVariable",-1,4 TO ,,t
   SYS "OS_ReadModeVariable",-1,11 TO ,,x:x=(x+1)<<t
   SYS "OS_ReadModeVariable",-1,5 TO ,,t
   SYS "OS_ReadModeVariable",-1,12 TO ,,y:y=(y+1)<<t

   Icon%=i%
   
   block%!0=loginHandle%
   SYS "Wimp_GetWindowInfo",,block%
   block%!12-=block%!4:block%!16-=block%!8
   block%!4=(x-block%!12)/2
   block%!8=(y-block%!16)/2
   block%!12+=block%!4:block%!16+=block%!8
   SYS "Wimp_OpenWindow",,block%
   SYS &2002B,!(loginTpl%+88+2*32+20) TO n$
   IF LEN(n$)>0 THEN SYS "Wimp_SetCaretPosition",loginHandle%,3,-1,-1,-1,0 ELSE SYS "Wimp_SetCaretPosition",loginHandle%,2,-1,-1,-1,0
ENDPROC


REM +-------------------------------------------------------------------+
REM |                                                                   |
REM |   Attach selection handling.                                      |
REM |                                                                   |
REM +-------------------------------------------------------------------+

REM Icon numbers for Attach template
REM    0 - OK
REM    1 - Cancel
REM    2 - Name to attach to
REM    3 - Server button
REM    4 - Tree button
REM    5 - Address button

DEF PROCattachclick(i%)
   IF DEBUG THEN SYS DEBUG,CHR$10+"attachclick("+STR$(i%)+") "
   
   CASE i% OF
      WHEN 0:REM ok
         PROCdoattach
      WHEN 1:REM cancel
         PROCcloseattach
      WHEN 3:REM radio
      WHEN 4:REM radio
      WHEN 5:REM radio
   ENDCASE
ENDPROC

REM ---------------------------------------------------------------------

DEF PROCcloseattach
   IF DEBUG THEN SYS DEBUG,CHR$10+"closeattach() "
   
   SYS "Wimp_CreateMenu",,-1
   block%!0=attachHandle%
   SYS "Wimp_CloseWindow",,block%
ENDPROC

REM ---------------------------------------------------------------------

DEF PROCdoattach
   LOCAL n$,mode,fs%,V
   IF DEBUG THEN SYS DEBUG,CHR$10+"doattach() "
   
   SYS &2002B,!(attachTpl%+88+2*32+20) TO n$
   mode=0
   block%!0=attachHandle%
   block%!4=3
   SYS "Wimp_GetIconState",,block%:IF (block%!24)AND(1<<21) THEN mode=1
   block%!0=attachHandle%
   block%!4=5
   SYS "Wimp_GetIconState",,block%:IF (block%!24)AND(1<<21) THEN mode=2
   
   PROCcloseattach
   
   IF n$<>"" THEN SYS "XNWClient_Attach",n$,mode TO fs%;V ELSE SYS "XNWClient_Attach",0,0 TO fs%;V
   IF (V AND 1)=0 THEN
      PROCmakeicons
      $(!(attachTpl%+88+2*32+20))=""
   ENDIF
ENDPROC

REM ---------------------------------------------------------------------

DEF PROCattachkey(i%,key%)
   IF DEBUG THEN SYS DEBUG,CHR$10+"attachkey("+STR$(i%)+",",STR$(key%)+") "
   
   CASE key% OF
      WHEN 27:
         PROCcloseattach
      WHEN 13:
         IF i%=2 THEN PROCdoattach
   ENDCASE
ENDPROC

REM ---------------------------------------------------------------------

DEF PROCattachwindow
   LOCAL x,y,t,n$
   IF DEBUG THEN SYS DEBUG,CHR$10+"attachwindow() "
   
   SYS "OS_ReadModeVariable",-1,4 TO ,,t
   SYS "OS_ReadModeVariable",-1,11 TO ,,x:x=(x+1)<<t
   SYS "OS_ReadModeVariable",-1,5 TO ,,t
   SYS "OS_ReadModeVariable",-1,12 TO ,,y:y=(y+1)<<t

   $(!(attachTpl%+88+2*32+20))=""
   block%!0=attachHandle%
   SYS "Wimp_GetWindowInfo",,block%
   block%!12-=block%!4:block%!16-=block%!8
   block%!4=(x-block%!12)/2
   block%!8=(y-block%!16)/2
   block%!12+=block%!4:block%!16+=block%!8
   SYS "Wimp_OpenWindow",,block%
   SYS "Wimp_SetCaretPosition",attachHandle%,2,-1,-1,-1,0
ENDPROC

REM ---------------------------------------------------------------------

DEF PROCdetach(i%)
   LOCAL V
   IF DEBUG THEN SYS DEBUG,CHR$10+"detach("+STR$(i%)+") fs="+STR$~(IconServer%(i%))
   
   IF IconServer%(i%) THEN SYS "XNWClient_Detach",IconServer%(i%) TO ;V
   IF (V AND 1)=0 THEN PROCmakeicons
ENDPROC


REM +-------------------------------------------------------------------+
REM |                                                                   |
REM |   Subroutines.                                                    |
REM |                                                                   |
REM +-------------------------------------------------------------------+

DEF PROCmakeicons
   LOCAL mt,i,n,p,localname,localname$,remotename,remotename$,flags,count,sname$,j%
   LOCAL fs%,V,server%,user%,ns
   LOCAL Server%(),ServerName$(),UserName$(),ServerUsed(),ServerLogged()
   DIM Server%(MAX_SERVERS),ServerName$(MAX_SERVERS),UserName$(MAX_SERVERS)
   DIM ServerUsed(MAX_SERVERS),ServerLogged(MAX_SERVERS)
   IF DEBUG THEN SYS DEBUG,CHR$10+"makeicons() "
   
   ServerName$()=""
   ServerUsed()=1
   Server%()=0
   fs%=0
   ns=0
   
   SYS "XOS_SWINumberFromString",,"NWClient_ServerList" TO ;V
   IF V AND 1 THEN
      SYS "XOS_ReadVarVal","NW$Connection",block%,200,0,0 TO ;V
      IF (V AND 1)=0 THEN
         ServerUsed(0)=0
         ns=1
      ENDIF
   ELSE
      REPEAT
         SYS "XNWClient_ServerList",fs% TO fs%,server%,user%,flags;V
         IF (V AND 1)=0 THEN
            Server%(ns)=fs%
            SYS &2002B,server% TO ServerName$(ns):ServerName$(ns)=FNlower(ServerName$(ns))
            IF user% THEN SYS &2002B,user% TO UserName$(ns) ELSE UserName$(n)=""
            ServerUsed(ns)=0
            ServerLogged(ns)=flags AND 1
            ns+=1
         ENDIF
      UNTIL (V AND 1)<>0 OR fs%=0 OR ns>=MAX_SERVERS
   ENDIF

   REM first do IconMode 3, mounted directory

   n=0
   mt=0
   REPEAT
      SYS "XNWClient_MountList",mt,0,0,0,0,0 TO mt,localname,remotename,flags,count,server%;V
      IF (V AND 1)=0 AND mt AND (flags AND &81)=0 THEN
         SYS &2002B,localname TO localname$
         SYS &2002B,remotename TO remotename$
         FOR i=0 TO ns-1
            IF server%=Server%(i) THEN
               IF ns>1 AND ServerName$(i)<>"" THEN remotename$=ServerName$(i)+"/"+remotename$
               ServerUsed(i)=1
            ENDIF
         NEXT
         PROCicon(n,localname$,3)
         IconMount%(n)=mt
         IconName$(n,1)=localname$
         IconName$(n,2)=remotename$
         IconServer%(n)=server%
         n+=1
      ENDIF
   UNTIL (V AND 1)<>0 OR mt=0 OR n>MAX_ICONS-1

   REM secondly do IconMode 2, logged in server without mount

   FOR i=0 TO MAX_SERVERS-1
      IF ServerUsed(i)=0 AND ServerLogged(i)<>0 AND n<MAX_ICONS-1 THEN
         PROCicon(n,ServerName$(i),2)
         IconMount%(n)=0
         IconName$(n,1)=""
         IconName$(n,2)=ServerName$(i)
         IconServer%(n)=Server%(i)
         n+=1
      ENDIF
   NEXT

   REM thirdly do IconMode 1, attached to server but not logged in

   FOR i=0 TO MAX_SERVERS-1
      IF ServerUsed(i)=0 AND ServerLogged(i)=0 AND n<MAX_ICONS-1 THEN
         IF ServerName$(i)="" THEN PROCicon(n,"nw "+STR$i,1) ELSE PROCicon(n,ServerName$(i),1)
         IconMount%(n)=0
         IconName$(n,1)=""
         IconName$(n,2)=ServerName$(i)
         IconServer%(n)=Server%(i)
         n+=1
      ENDIF
   NEXT
   
   REM finally do IconMode 0, the attach-only icon
   
   IF ns=0 THEN
      PROCicon(n,"Attach",0)
      IconMount%(n)=0
      IconName$(n,1)=""
      IconName$(n,2)=""
      IconServer%(n)=0
      n+=1
   ENDIF
 
   WHILE n<MAX_ICONS
      PROCkillicon(n)
      n+=1
   ENDWHILE
ENDPROC

REM ---------------------------------------------------------------------

DEF PROCkillicon(i)
   IF Icons%(i) THEN block%!0=-2:block%!4=Icons%(i):SYS "Wimp_DeleteIcon",,block%
   Icons%(i)=0:IconName$(i,0)="":IconName$(i,1)="":IconName$(i,2)="":IconMode(i)=-1:IconMount%(i)=0:IconServer%(i)=0
ENDPROC

REM ---------------------------------------------------------------------

DEF PROCicon(x,name$,mode)
   IF name$<>IconName$(x,0) OR mode<>IconMode(x) THEN
      PROCkillicon(x)

      width=(spr%!32+1)*4:height=(spr%!36+1)*2
      block%!0=-6      :REM position indicator
      block%!4=0       :REM xpos
      block%!8=-16     :REM ypos
      block%!12=width
      block%!16=height-16+36
      block%!20=&1700610B

      IconName$(x,0)=name$
      IconMode(x)=mode

      $(IconLabel%+x*16)=IconName$(x,0)
      block%!24=IconLabel%+x*16:block%!28=sprname%+16*mode
      block%!32=4
      SYS "Wimp_CreateIcon",&58000010-x,block% TO Icons%(x)
   ENDIF
ENDPROC

REM ---------------------------------------------------------------------

DEF PROCerror
   !block%=ERRN:$(block%+4)=REPORT$+" (internal code "+STR$ERRL+"/"+STR$ERRN+")."+CHR$0
   SYS "Wimp_ReportError",block%,1,"NWClient"
   SYS "Wimp_CloseDown"
END

REM ---------------------------------------------------------------------

DEF FNlower(n$)
   LOCAL i%,c%,r$
   FOR i%=1 TO LEN(n$):c%=ASCMID$(n$,i%,1)
      IF c%>64 AND c%<90 THEN r$+=CHR$(c%+32) ELSE r$+=CHR$c%
   NEXT
=r$

REM ---------------------------------------------------------------------

DEF PROCsetup
   LOCAL r$,t$,i,n$,r2,V
   DIM infoTpl% 1536,loginTpl% 1536,mountTpl% 1536,attachTpl% 1024,detachTpl% 1024
   IF DEBUG THEN SYS DEBUG,CHR$10+"setup() "
   
   SYS "Wimp_OpenTemplate",,"<NWLogin$Dir>.Templs"

   SYS "Wimp_LoadTemplate",,infoTpl%,infoTpl%+800,infoTpl%+1500,-1,"Info",0
   infoTpl%!24=-1:infoTpl%!28=infoTpl%!28 OR %10:SYS "Wimp_CreateWindow",,infoTpl% TO infoHandle%
   
   r$=FNmodule(&cf00)
   IF r$<>"" THEN
      i=INSTR(r$,CHR$9):IF i>0 THEN
         IF INSTR(r$,CHR$9,i+1)>0 THEN i=INSTR(r$,CHR$9,i+1)
         r$="RiscIPX ["+MID$(r$,i+1,4)+"]" ELSE r$=""
      ENDIF
   ELSE
      r$="No RiscIPX"
   ENDIF

   n$=FNmodule(&cf40)
   IF n$<>"" THEN
      i=INSTR(n$,CHR$9):IF i>0 THEN
         IF INSTR(n$,CHR$9,i+1)>0 THEN i=INSTR(n$,CHR$9,i+1)
         n$="NWClient ["+MID$(n$,i+1,4)+"]" ELSE n$=""
      ENDIF
   ELSE
      n$="No NWClient"
   ENDIF
   $(!(infoTpl%+88+4*32+20))=r$+"  "+n$

   SYS "Wimp_LoadTemplate",,loginTpl%,loginTpl%+1000,loginTpl%+1500,-1,"Login",0
   loginTpl%!24=-1:loginTpl%!28=loginTpl%!28 OR %10:SYS "Wimp_CreateWindow",,loginTpl% TO loginHandle%
   $(!(loginTpl%+88+2*32+20))="":$(!(loginTpl%+88+3*32+20))=""
   SYS "XOS_ReadVarVal","NW$User",block%,200,0,0 TO ,,r2;V:IF r2>0 THEN block%?r2=0
   IF (V AND 1)=0 THEN SYS &2002B,block% TO n$:$(!(loginTpl%+88+2*32+20))=n$
   $(!(loginTpl%+88+3*32+20))=""

   SYS "Wimp_LoadTemplate",,mountTpl%,mountTpl%+1000,mountTpl%+1500,-1,"Mount",0
   mountTpl%!24=-1:mountTpl%!28=mountTpl%!28 OR %10:SYS "Wimp_CreateWindow",,mountTpl% TO mountHandle%

   SYS "Wimp_LoadTemplate",,attachTpl%,attachTpl%+800,attachTpl%+1000,-1,"Attach",0
   attachTpl%!24=-1:attachTpl%!28=attachTpl%!28 OR %10:SYS "Wimp_CreateWindow",,attachTpl% TO attachHandle%

   SYS "Wimp_LoadTemplate",,detachTpl%,detachTpl%+800,detachTpl%+1000,-1,"Detach",0
   detachTpl%!24=-1:detachTpl%!28=detachTpl%!28 OR %10:SYS "Wimp_CreateWindow",,detachTpl% TO detachHandle%

   SYS "Wimp_CloseTemplate"

   sprsize%=10240
   DIM spr% sprsize%
   !spr%=sprsize%:spr%!4=0:spr%!8=16:spr%!12=16
   SYS "OS_SpriteOp",266,spr%,"<NWLogin$Dir>.!sprites"
   
   $(sprname%+0*16)="Sgrey"
   $(sprname%+1*16)="Sgrey"
   $(sprname%+2*16)="S!nwclient"
   $(sprname%+3*16)="S!nwclient"
ENDPROC

REM ---------------------------------------------------------------------

DEF FNmodule(swi)
   LOCAL m,i,base,t$
   m=0:i=0
   REPEAT
      SYS "XOS_Module",12,m,i TO ,m,i,base;V
   UNTIL (base!&1c=swi) OR (V AND 1)<>0
   IF V AND 1 THEN =""
   SYS &2002B,base+(base!&14) TO t$
=t$

REM ---------------------------------------------------------------------

DEF FNinitmenu(style)
   LOCAL p%
   IF DEBUG THEN SYS DEBUG,CHR$10+"initmenu() "
   
   $menu%="NWClient"
   menu%!12=&00070207
   menu%!16=100:REM width
   menu%!20=44:REM height
   menu%!24=0

   p%=menu%+28
   p%!0=&00000000:p%!4=infoHandle%:p%!8=&7000021:$(p%+12)="Info":p%+=24

   CASE style OF
      WHEN 0:REM no attachments
         p%!0=&00000000:p%!4=0            :p%!8=&7400021:$(p%+12)="Login":p%+=24
         p%!0=&00000000:p%!4=attachHandle%:p%!8=&7000021:$(p%+12)="Attach":p%+=24
         p%!0=&00000000:p%!4=0            :p%!8=&7400021:$(p%+12)="Detach":p%+=24
         p%!0=&00000080:p%!4=0            :p%!8=&7000021:$(p%+12)="Quit":p%+=24
      WHEN 1:REM attached to server
         p%!0=&00000000:p%!4=loginHandle% :p%!8=&7000021:$(p%+12)="Login":p%+=24
         p%!0=&00000000:p%!4=attachHandle%:p%!8=&7000021:$(p%+12)="Attach":p%+=24
         p%!0=&00000000:p%!4=0            :p%!8=&7000021:$(p%+12)="Detach":p%+=24
         p%!0=&00000080:p%!4=0            :p%!8=&7000021:$(p%+12)="Quit":p%+=24
      WHEN 2:REM logged in but no mount
         p%!0=&00000000:p%!4=mountHandle% :p%!8=&7000021:$(p%+12)="Mount":p%+=24
         p%!0=&00000000:p%!4=0            :p%!8=&7400021:$(p%+12)="Dismount":p%+=24
         p%!0=&00000000:p%!4=0            :p%!8=&7000021:$(p%+12)="Logout":p%+=24
         p%!0=&00000000:p%!4=attachHandle%:p%!8=&7000021:$(p%+12)="Attach":p%+=24
         p%!0=&00000080:p%!4=0            :p%!8=&7400021:$(p%+12)="Free":p%+=24
      WHEN 3:REM mounted directory
         p%!0=&00000000:p%!4=mountHandle% :p%!8=&7000021:$(p%+12)="Mount":p%+=24
         p%!0=&00000000:p%!4=0            :p%!8=&7000021:$(p%+12)="Dismount":p%+=24
         p%!0=&00000000:p%!4=0            :p%!8=&7000021:$(p%+12)="Logout":p%+=24
         p%!0=&00000000:p%!4=attachHandle%:p%!8=&7000021:$(p%+12)="Attach":p%+=24
         p%!0=&00000080:p%!4=0            :p%!8=&7000021:$(p%+12)="Free":p%+=24
   ENDCASE
=(p%-menu%-28)/24

REM ----- EOF -----
