/* #------------------------------------------------------------------------#
   |                                                                        |
   |   FSDIRS.C                                                             |
   |                                                                        |
   |   Directory scanning.                                                  |
   |                                                                        |
   |   Copyright 1999, Frank A. Vorstenbosch.                               |
   |                                                                        |
   #------------------------------------------------------------------------# */

/* $Id: fsdirs.c,v 1.7 2001/12/22 12:19:50 frank Exp $ */

#define VERSION 0x00090

#include "nwclient.h"

extern int nwclient_init_search_num(struct Mount *mt,int directory,char Sequence[10],struct NWClient *nw);

void FlushDirCache(struct Mount *mt,struct NWClient *nw)
{  struct DirCache *cache,*tmp;

   Trace("\n Delete old cache");
   if(mt->ScanDirName)
      free(mt->ScanDirName);
   mt->ScanDirName=NULL;

   forList2(&mt->ScanDirCache,cache,tmp)
   {  
      RemoveNode(cache);
      free(cache);
   }
}

#pragma On(Check_ltorg)                  /* most of these functions are too big */

struct kernel_error *ReadDirEntries(struct NWClient *nw,const char *dirName,char *buffer,
                    int numObjects,int firstItem,int bufSize,int method /*14,15,19*/)
{  int i,r,len,offset;
   struct Mount *mt;
   struct Server *fs;
   struct File *file;
   int date[2],entry_DosDirNum;
   char info[FILENAME_MAX];
   struct DirCache *cache,*tmp;
   struct DirEntry *entry;

   struct Record15
   {  int Load,
          Execution,
          Length,
          Attributes,
          Type;
      char Name[1]; };

   struct Record19
   {  int Load,
          Execution,
          Length,
          Attributes,
          Type,
          ObjectID,
          DateLo;
      char DateHi,
           Name[1]; };

   #if defined DEBUG
   char *dumpbuf=buffer; int dumpsize=bufSize; for(i=0;i<dumpsize;i++) dumpbuf[i]='-';
   Trace("\n ReadDirEntries(");
   Trace(dirName);
   TraceChar(',');
   TraceVal((int)buffer);
   TraceChar(',');
   TraceVal((int)numObjects);
   TraceChar(',');
   TraceVal((int)firstItem);
   TraceChar(',');
   TraceVal((int)bufSize);
   TraceChar(',');
   TraceVal((int)method);
   Trace(") ");
   #endif

   if((mt=RosToNWName(info,dirName,nw,0))==NULL)
      return &Error_InvalidName;

   fs=mt->Server;

   if((mt->Flags&MOUNT_RESCANDIR) || !mt->ScanDirName || strcmp(mt->ScanDirName,info))
   {  /* have to setup new scan here */

      FlushDirCache(mt,nw);
      mt->ScanDirName=strdup(info);

      /* ----- setup for scan ----------------------------------------------------- */

      Trace("\n Setup for scan");

      fs->request.header.Function=0x57;
      fs->request.payload.fn_57.SubFunction=0x16;     /* generate directory handle */
      fs->request.payload.fn_57_16.NameSpace=(mt->Flags&MOUNT_LONGNAMES);       /* namespace (0 for DOS or 4 for OS/2 */
      fs->request.payload.fn_57_16.Volume=mt->Volume;;      /* volume number */
      fs->request.payload.fn_57_16.Directory=mt->Directory; /* dir_base */
      fs->request.payload.fn_57_16.HandleFlag=1;            /* we have a dir_base */
      fs->request.payload.fn_57_16.PathBytes=make_path(&fs->request.payload.fn_57_16.PathComponents,mt->ScanDirName);

      Trace("\n fs->request.payload.fn_57_16.PathBytes=");TraceVal(fs->request.payload.fn_57_16.PathBytes);

      if((r=ncp_request(REQ_57"b3z"REQ_PATH,"llb",NULL,fs))!=0)
         return &Error_NotFound;

      mt->ScanDosDirNumber=nw->reply.payload.fn_57_16.DosDirectory;
      mt->ScanDirNumber=nw->reply.payload.fn_57_16.Directory;

      if((r=nwclient_init_search_num(mt,mt->ScanDirNumber,mt->Sequence,nw))!=0)
         return &Error_NotFound;
      mt->ScanItem=0;

      /* ----- now build the directory -------------------------------------------- */
      
      Trace("\n Now build the directory");

      cache=NULL;
      while((r=nwclient_search(mt,info))==0)
      {
         /* ----- add more memory if needed ----- */
         
         len=strlen(info);
         if(!cache || cache->SpaceLeft<(sizeof(struct DirEntry)+len+1))
         {  
            Trace("\n\n add more memory \n");
            if(len>(CACHE_BLOCKSIZE-100) || (cache=malloc(CACHE_BLOCKSIZE))==NULL)
            {  free(mt->ScanDirName);
               mt->ScanDirName=NULL;
               forList2(&mt->ScanDirCache,cache,tmp)
               {  free(cache);
                  RemoveNode(cache);
               }
               return &Error_NoMemory;
            }

            #if defined DEBUG && DEBUG&2
            Trace(" mt->ScanDirCache=");TraceVal((int)&mt->ScanDirCache);
            Trace(" cache=");TraceVal((int)cache);
            memset((char *)cache,'-',CACHE_BLOCKSIZE);
            #endif

            AddHead(&mt->ScanDirCache,cache);

            cache->SpaceLeft=CACHE_BLOCKSIZE-(((char *)&cache->Entries[0])-(char *)cache);
            cache->NumEntries=0;
         }

         /* ----- set filename ----- */

         entry=&cache->Entries[cache->NumEntries];

         #if defined DEBUG && DEBUG&2
         Trace("\n set filename, entry=");
         TraceVal((int)entry);
         entry->_pad=('0'+(((cache->NumEntries)/10)%10)) |
                     ('0'+((cache->NumEntries)%10)) <<8;
         #endif

         entry->NameOffset=cache->SpaceLeft-len-1;
         NWToRosName(mt,((char *)entry)+entry->NameOffset,info);
         cache->SpaceLeft-=sizeof(struct DirEntry)+len+1;

         #if defined DEBUG && DEBUG&2
         Trace(" SpaceLeft=");
         TraceVal((int)cache->SpaceLeft);
         #endif
         
         /* ----- set basic attributes ----- */

         entry->FullType[0]=entry->FullType[1]=
            entry->Attributes=entry->DataStreamSize=
            entry->DirEntNum=entry->VolNumber=
            entry->ModifyTime=entry->ModifyDate=0;

         fs->request.header.Function=0x57;
         fs->request.payload.fn_57.SubFunction=0x06;     /* get info */
         fs->request.payload.fn_57_06.NameSpace=(mt->Flags&MOUNT_LONGNAMES);       /* namespace (0 for DOS or 4 for OS/2 */
         fs->request.payload.fn_57_06.DestNameSpace=(mt->Flags&MOUNT_LONGNAMES);  /* namespace (0 for DOS or 4 for OS/2 */
         fs->request.payload.fn_57_06.SearchAttributes=0x8006;
         fs->request.payload.fn_57_06.RIM=RIM_ALL;
         fs->request.payload.fn_57_06.Volume=mt->Volume;
         fs->request.payload.fn_57_06.Directory=mt->ScanDirNumber;
         fs->request.payload.fn_57_06.HandleFlag=1;      /* have a dirbase */
         fs->request.payload.fn_57_06.PathBytes=make_path(&fs->request.payload.fn_57_06.PathComponents,info);
         if(ncp_request("3bwl"REQ_PATH,ENTRY_INFO,info,fs)>=0)
         {  
            Trace("\n Got basic attributes OK");

            entry->Attributes=nw->reply.payload.fn_57_06.Attributes;
            entry->DataStreamSize=nw->reply.payload.fn_57_06.DataStreamSize;
            entry->DirEntNum=nw->reply.payload.fn_57_06.DirEntNum;
            entry_DosDirNum=nw->reply.payload.fn_57_06.DosDirNum;
            entry->VolNumber=nw->reply.payload.fn_57_06.VolNumber;
            entry->ModifyTime=nw->reply.payload.fn_57_06.ModifyTime;
            entry->ModifyDate=nw->reply.payload.fn_57_06.ModifyDate;

            if(entry->Attributes&ATTR_DIR)
               entry->FullType[0]=0xfff00000;
            else
            {
               /* ----- check for ncpfs attributes (symlinks, UNIX exec) ----- */

               #if defined DEBUG && DEBUG&2
               Trace("\n Attributes");
               TraceVal(entry->Attributes);

               if(entry->Attributes&(ATTR_SHARED|ATTR_HIDDEN|ATTR_SYSTEM))
                  Trace(" Special");
               #endif

               switch(entry->Attributes&(ATTR_SHARED|ATTR_HIDDEN|ATTR_SYSTEM))
               {  case ATTR_SHARED:
                     /* just informative */
                     break;
                  case ATTR_SHARED|ATTR_HIDDEN:
                     if(entry->DataStreamSize>8 && entry->DataStreamSize<=NCP_MAX_SYMLINK_SIZE)
                     {  entry->FullType[0]=0xfff00000|(SOFTLINK<<8);
                        entry->FullType[1]=0; }
                     break;
                  case ATTR_SHARED|ATTR_SYSTEM:
                     entry->FullType[0]=0xfff00000|(UNIXEXEC<<8);
                     entry->FullType[1]=0;
                     break;
                  case ATTR_SHARED|ATTR_HIDDEN|ATTR_SYSTEM:
                     /* reserved case */
                     break;
               }

               /* ----- read file type or load and execute addresses ----- */
            
               if(!entry->FullType[0])
               {
                  fs->request.header.Function=0x56;
                  fs->request.payload.fn_56_02.SubFunction=0x03;
                  fs->request.payload.fn_56_03.Flags=0;
                  fs->request.payload.fn_56_03.Is.Entry.Volume=entry->VolNumber;
                  fs->request.payload.fn_56_03.Is.Entry.DirEntry=entry_DosDirNum;
                  fs->request.payload.fn_56_03.Position=0;
                  fs->request.payload.fn_56_03.Length=8;

                  if((mt->Flags&MOUNT_LONGNAMES) && ncp_request("bw4lk\006zkrkikskckoks","4lw=3e?*b",NULL,fs)>=0 && nw->reply.payload.fn_56_03.Error==0)
                  {  fs->request.header.Function=0x56;
                     fs->request.payload.fn_56_02.SubFunction=1;
                     fs->request.payload.fn_56_01.EAHandle=nw->reply.payload.fn_56_03.EAHandle;
                     ncp_request("bzzl",NULL,NULL,fs);

                     #if defined DEBUG && DEBUG&2
                     if(nw->reply.payload.fn_56_03.Length==8)
                     {  Trace("\n Load/execute=");
                        TraceVal(nw->reply.payload.fn_56_03.Contents.FullType[0]);
                        TraceVal(nw->reply.payload.fn_56_03.Contents.FullType[1]); }
                     else if(nw->reply.payload.fn_56_03.Length==2)
                     {  Trace("\n Type is");
                        TraceVal(nw->reply.payload.fn_56_03.Contents.Value);}
                     else
                        Trace("\n Untyped");
                     #endif

                     if(nw->reply.payload.fn_56_03.Length==8)
                     {  entry->FullType[0]=nw->reply.payload.fn_56_03.Contents.FullType[0];
                        entry->FullType[1]=nw->reply.payload.fn_56_03.Contents.FullType[1];
                     }
                     else if(nw->reply.payload.fn_56_03.Length==2)
                     {  if(nw->reply.payload.fn_56_03.Contents.Value&0xf000)
                           entry->FullType[0]=entry->FullType[1]=(nw->reply.payload.fn_56_03.Contents.Value==-1)?0:0xdeaddead;
                        else
                           entry->FullType[0]=0xfff00000|(nw->reply.payload.fn_56_03.Contents.Value<<8);
                     }
                     else
                        entry->FullType[0]=InventFileType(nw,info);
                  }
                  else
                     entry->FullType[0]=InventFileType(nw,info);
               }  /* end if type not already set */
            }  /* end if not a directory */
         }  /* end if ncp request result OK */

         cache->NumEntries++;
      }
      mt->Flags&=~MOUNT_RESCANDIR;

      Trace(" Number of entries=");
      TraceVal(cache->NumEntries);
   }

   /* ----- now return the cached entries that the user asked for -------------- */

   Trace("\n Return entries, method=");
   TraceVal(method);
   Trace(" firstItem=");
   TraceVal(firstItem);
   Trace(" numObjects=");
   TraceVal(numObjects);
   Trace(" bufSize=");
   TraceVal(bufSize);

   switch(method)
   {  case 15:
         offset=20;
         break;
      case 19:
         offset=29;
         break;
      default:
         offset=0;
   }

   nw->ReturnStruct[3]=0;
   r=0;

   forList(&mt->ScanDirCache,cache)
   {  Trace("\n Cache block"); TraceVal((int)cache);
      if(firstItem<r+cache->NumEntries)
      {  Trace("\n Have to scan through them one by one");

         for(i=firstItem>r?firstItem-r:0,r+=i;i<cache->NumEntries;i++,r++)
         {  
            Trace("\n item");
            TraceVal(i);

            Trace(" copy");

            entry=&cache->Entries[i];
            len=strlen(((char *)entry)+entry->NameOffset)+1;

            bufSize-=offset+len;

            if(bufSize<0)     /* it doesn't fit in the supplied buffer */
            {  nw->ReturnStruct[4]=r/*+1*/;
               return NULL; }

            strcpy(buffer+offset,((char *)entry)+entry->NameOffset);
            NWToRosDate(date,entry->ModifyDate,entry->ModifyTime,nw->TimeOffset);

            if(method>14)
            {
               if(entry->Attributes&ATTR_DIR)
                  ((struct Record15 *)buffer)->Type=2;
               else
               {  ((struct Record15 *)buffer)->Type=1;

                  forList(&mt->Files,file)
                     if(file->DirEntNum==entry->DirEntNum && 
                        file->VolNumber==entry->VolNumber)
                  {
                     Trace(" Open file, size now ");
                     TraceVal(file->CurrentSize);
                     entry->DataStreamSize=file->CurrentSize;
                  }
               }

               ((struct Record15 *)buffer)->Length=entry->DataStreamSize;
               ((struct Record15 *)buffer)->Attributes=RosAttrib(entry->Attributes);
            }

            switch(method)
            {  default:
                  buffer+=offset+len;
                  break;
               case 15:
                  if((entry->FullType[0]&0xfff00000)==0xfff00000)
                  {  ((struct Record15 *)buffer)->Load=entry->FullType[0]|date[1];  /* type and date top */
                     ((struct Record15 *)buffer)->Execution=date[0]; }                   /* date bottom       */
                  else
                  {  ((struct Record15 *)buffer)->Load=entry->FullType[0];
                     ((struct Record15 *)buffer)->Execution=entry->FullType[1]; }
                  buffer+=offset+len;
                  while(((int)buffer)&3)
                     *buffer++=0;
                  break;
               case 19:
                  ((struct Record19 *)buffer)->Load=entry->FullType[0];
                  ((struct Record19 *)buffer)->Execution=entry->FullType[1];
                  ((struct Record19 *)buffer)->ObjectID=entry->DirEntNum;
                  ((struct Record19 *)buffer)->DateLo=date[0];
                  ((struct Record19 *)buffer)->DateHi=date[1];
                  buffer+=offset+len;
                  while(((int)buffer)&3)
                     *buffer++=0;
                  break;
            }

            nw->ReturnStruct[3]++;

            if(--numObjects==0)        /* this was the last one the user wanted */
            {  nw->ReturnStruct[4]=r+1;
               return NULL; }

         }  /* end for all entries in this cache block */
      }
      else
         r+=cache->NumEntries;
   }

   Trace(" ran off end of cache");

   nw->ReturnStruct[4]=-1;

   return NULL;
}


/* ----- EOF FSDIRS.C ----- */

