
#ifndef NCP_ERRORS
#define NCP_ERRORS

/* +------------------------------------------------------------------------+
   |                                                                        |
   |   IPX errors.                                                          |
   |   All these values fit in an immediate field for convenience.          |
   |                                                                        |
   +------------------------------------------------------------------------+ */

#define IPX_NO_PACKETS_READY     -257
#define IPX_INVALID_ADDRESS      -258
#define IPX_NOT_ATTACHED         -259
#define IPX_CANNOT_BIND          -261  /* someone else has port and packettype in use */
#define IPX_UNIMPLEMENTED        -265
#define IPX_NO_ROUTE_TO_NETWORK  -269
#define IPX_NOT_ENOUGH_MEMORY    -273
#define IPX_TRANSMIT_ERROR       -277
#define IPX_NO_SOCKET            -281
#define IPX_PACK_INVALID         -285  /* Note: keep the copy in packer.arm in sync */
#define IPX_PACK_NO_SPACE        -289  /* Note: keep the copy in packer.arm in sync */
#define IPX_PACK_MULTIPLIER      -293  /* Note: keep the copy in packer.arm in sync */


/* +------------------------------------------------------------------------+
   |                                                                        |
   |   NCP errors.                                                          |
   |                                                                        |
   +------------------------------------------------------------------------+ */

/* In ncp_request, we return the 2-s complement of the error byte
   that the NCP request packet holds, this way we are compatible with
   the error codes that NDS returns and we also make sure that all
   errors are negative values.
   The DOS client sometimes returns the NCP errors offset by 0x8900
*/

#define NCP_INSUFFICIENT_SPACE          (-0x01)  /* 001 */
#define NCP_INTRUDER_LOCKOUT            (-0x3b)  /* 059 */
#define NCP_BUFFER_TOO_SMALL            (-0x77)  /* 119 */
#define NCP_VOL_FLAG_NOT_SET            (-0x78)  /* 120 the service requested, not avail. on the selected vol. */
#define NCP_NO_ITEMS_FOUND              (-0x79)  /* 121 */
#define NCP_CONN_ALREADY_TEMP           (-0x7a)  /* 122 */
#define NCP_CONN_ALREADY_LOGGED_IN      (-0x7b)  /* 123 */
#define NCP_CONN_NOT_AUTHENTICATED      (-0x7c)  /* 124 */
#define NCP_CONN_NOT_LOGGED_IN          (-0x7d)  /* 125 */
#define NCP_NCP_BOUNDARY_CHECK_FAILED   (-0x7e)  /* 126 */
#define NCP_LOCK_WAITING                (-0x7f)  /* 127 */
#define NCP_LOCK_FAIL                   (-0x80)  /* 128 */
#define NCP_FILE_IN_USE                 (-0x80)  /* 128 */
#define NCP_FILE_NO_HANDLES             (-0x81)  /* 129 */
#define NCP_FILE_NO_OPEN_PRIV           (-0x82)  /* 130 */
#define NCP_DISK_IO_ERROR               (-0x83)  /* 131 */
#define NCP_FILE_NO_CREATE_PRIV         (-0x84)  /* 132 */
#define NCP_FILE_NO_CREATE_DEL_PRIV     (-0x85)  /* 133 */
#define NCP_FILE_EXISTS_READ_ONLY       (-0x86)  /* 134 */
#define NCP_FILE_WILD_CARDS_IN_NAME     (-0x87)  /* 135 */
#define NCP_FILE_INVALID_HANDLE         (-0x88)  /* 136 */
#define NCP_FILE_NO_SRCH_PRIV           (-0x89)  /* 137 */
#define NCP_FILE_NO_DEL_PRIV            (-0x8a)  /* 138 */
#define NCP_FILE_NO_RENAME_PRIV         (-0x8b)  /* 139 */
#define NCP_FILE_NO_MOD_PRIV            (-0x8c)  /* 140 */
#define NCP_FILE_SOME_IN_USE            (-0x8d)  /* 141 */
#define NCP_FILE_NONE_IN_USE            (-0x8e)  /* 142 */
#define NCP_FILE_SOME_READ_ONLY         (-0x8f)  /* 143 */
#define NCP_FILE_NONE_READ_ONLY         (-0x90)  /* 144 */
#define NCP_FILE_SOME_RENAMED_EXIST     (-0x91)  /* 145 */
#define NCP_FILE_NONE_RENAMED_EXIST     (-0x92)  /* 146 */
#define NCP_FILE_NO_READ_PRIV           (-0x93)  /* 147 */
#define NCP_FILE_NO_WRITE_PRIV          (-0x94)  /* 148 */
#define NCP_FILE_READ_ONLY              (-0x94)  /* 148 */
#define NCP_FILE_DETACHED               (-0x95)  /* 149 */
#define NCP_SERVER_OUT_OF_MEMORY        (-0x96)  /* 150 */
#define NCP_DIR_TARGET_INVALID          (-0x86)  /* 150 */
#define NCP_DISK_NO_SPOOL_SPACE         (-0x97)  /* 151 */
#define NCP_VOL_INVALID                 (-0x98)  /* 152 */
#define NCP_DIR_FULL                    (-0x99)  /* 153 */
#define NCP_VOL_RENAMING_ACROSS         (-0x9a)  /* 154 */
#define NCP_DIRHANDLE_INVALID           (-0x9b)  /* 155 */
#define NCP_PATH_INVALID                (-0x9c)  /* 156 */
#define NCP_TRUSTEES_NO_MORE            (-0x9c)  /* 156 */
#define NCP_DIRHANDLE_NO_MORE           (-0x9d)  /* 157 */
#define NCP_FILE_NAME_INVALID           (-0x9e)  /* 158 */
#define NCP_DIR_ACTIVE                  (-0x9f)  /* 159 */
#define NCP_DIR_NOT_EMPTY               (-0xa0)  /* 160 */
#define NCP_DIR_IO_ERROR                (-0xa1)  /* 161 */
#define NCP_FILE_IO_LOCKED              (-0xa2)  /* 162 */
#define NCP_TTS_RANSACTION_RESTARTED    (-0xa3)  /* 163 */
#define NCP_DIR_RENAME_INVALID          (-0xa4)  /* 164 */
#define NCP_FILE_OPENCREAT_MODE_INVALID (-0xa5)  /* 165 */
#define NCP_ALREADY_IN_USE              (-0xa6)  /* 166 */
#define NCP_RESOURCE_TAG_INVALID        (-0xa7)  /* 167 */
#define NCP_ACCESS_DENIED               (-0xa8)  /* 168 */
#define NCP_DATA_STREAM_INVALID         (-0xbe)  /* 190 */
#define NCP_NAME_SPACE_INVALID          (-0xbf)  /* 191 */
#define NCP_ACCTING_NO_PRIV             (-0xc0)  /* 192 */
#define NCP_ACCTING_NO_BALANCE          (-0xc1)  /* 193 */
#define NCP_ACCTING_NO_CREDIT           (-0xc2)  /* 194 */
#define NCP_ACCTING_TOO_MANY_HOLDS      (-0xc3)  /* 195 */
#define NCP_ACCTING_DISABLED            (-0xc4)  /* 196 */
#define NCP_LOGIN_LOCKOUT               (-0xc5)  /* 197 */
#define NCP_CONSOLE_NO_PRIV             (-0xc6)  /* 198 */
#define NCP_Q_IO_FAILURE                (-0xd0)  /* 208 */
#define NCP_Q_NONE                      (-0xd1)  /* 209 */
#define NCP_Q_NO_SERVER                 (-0xd2)  /* 210 */
#define NCP_Q_NO_RIGHTS                 (-0xd3)  /* 211 */
#define NCP_Q_FULL                      (-0xd4)  /* 212 */
#define NCP_Q_NO_JOB                    (-0xd5)  /* 213 */
#define NCP_Q_NO_JOB_RIGHTS             (-0xd6)  /* 214 */
#define NCP_PASSWORD_UNENCRYPTED        (-0xd6)  /* 214 */
#define NCP_Q_IN_SERVICE                (-0xd7)  /* 215 */
#define NCP_PASSWORD_NOT_UNIQUE         (-0xd7)  /* 215 */
#define NCP_Q_NOT_ACTIVE                (-0xd8)  /* 216 */
#define NCP_PASSWORD_TOO_SHORT          (-0xd8)  /* 216 */
#define NCP_Q_STN_NOT_SERVER            (-0xd9)  /* 217 */
#define NCP_LOGIN_NO_CONN               (-0xd9)  /* 217 */
#define NCP_LOGIN_MAX_EXCEEDED          (-0xd9)  /* 217 */
#define NCP_Q_HALTED                    (-0xda)  /* 218 */
#define NCP_LOGIN_UNAUTHORIZED_TIME     (-0xda)  /* 218 */
#define NCP_LOGIN_UNAUTHORIZED_STATION  (-0xdb)  /* 219 */
#define NCP_Q_MAX_SERVERS               (-0xdb)  /* 219 */
#define NCP_ACCT_DISABLED               (-0xdc)  /* 220 */
#define NCP_PASSWORD_INVALID            (-0xde)  /* 222 */
#define NCP_PASSWORD_EXPIRED            (-0xdf)  /* 223 */
#define NCP_LOGIN_NO_CONN_AVAIL         (-0xe0)  /* 224 */
#define NCP_E_NO_MORE_USERS             (-0xe7)  /* 231 */
#define NCP_BIND_NOT_ITEM_PROP          (-0xe8)  /* 232 */
#define NCP_BIND_WRITE_TO_GROUP_PROP    (-0xe8)  /* 232 */
#define NCP_BIND_MEMBER_ALREADY_EXISTS  (-0xe9)  /* 233 */
#define NCP_BIND_NO_SUCH_MEMBER         (-0xea)  /* 234 */
#define NCP_BIND_NOT_GROUP_PROP         (-0xeb)  /* 235 */
#define NCP_BIND_NO_SUCH_SEGMENT        (-0xec)  /* 236 */
#define NCP_BIND_PROP_ALREADY_EXISTS    (-0xed)  /* 237 */
#define NCP_BIND_OBJ_ALREADY_EXISTS     (-0xee)  /* 238 */
#define NCP_BIND_NAME_INVALID           (-0xef)  /* 239 */
#define NCP_BIND_WILDCARD_INVALID       (-0xf0)  /* 240 */
#define NCP_BIND_SECURITY_INVALID       (-0xf1)  /* 241 */
#define NCP_BIND_OBJ_NO_READ_PRIV       (-0xf2)  /* 242 */
#define NCP_BIND_OBJ_NO_RENAME_PRIV     (-0xf3)  /* 243 */
#define NCP_BIND_OBJ_NO_DELETE_PRIV     (-0xf4)  /* 244 */
#define NCP_BIND_OBJ_NO_CREATE_PRIV     (-0xf5)  /* 245 */
#define NCP_BIND_PROP_NO_DELETE_PRIV    (-0xf6)  /* 246 */
#define NCP_BIND_PROP_NO_CREATE_PRIV    (-0xf7)  /* 247 */
#define NCP_BIND_PROP_NO_WRITE_PRIV     (-0xf8)  /* 248 */
#define NCP_BIND_PROP_NO_READ_PRIV      (-0xf9)  /* 249 */
#define NCP_NO_FREE_CONN_SLOTS          (-0xf9)  /* 249 */
#define NCP_NO_MORE_SERVER_SLOTS        (-0xfa)  /* 250 */
#define NCP_TEMP_REMAP_ERROR            (-0xfa)  /* 250 */
#define NCP_PARAMETERS_INVALID          (-0xfb)  /* 251 */
#define NCP_BIND_NO_SUCH_PROP           (-0xfb)  /* 251 */
#define NCP_NCP_NOT_SUPPORTED           (-0xfb)  /* 251 */
#define NCP_INET_PACKET_REQ_CANCELED    (-0xfc)  /* 252 */
#define NCP_SERVER_UNKNOWN              (-0xfc)  /* 252 */
#define NCP_MSG_Q_FULL                  (-0xfc)  /* 252 */
#define NCP_BIND_NO_SUCH_OBJ            (-0xfc)  /* 252 */
#define NCP_LOCK_COLLISION              (-0xfd)  /* 253 */
#define NCP_CONN_NUM_INVALID            (-0xfd)  /* 253 */
#define NCP_PACKET_LEN_INVALID          (-0xfd)  /* 253 */
#define NCP_UNKNOWN_REQ                 (-0xfd)  /* 253 */
#define NCP_BIND_LOCKED                 (-0xfe)  /* 254 */
#define NCP_TRUSTEE_NOT_FOUND           (-0xfe)  /* 254 */
#define NCP_DIR_LOCKED                  (-0xfe)  /* 254 */
#define NCP_SEM_INVALID_NAME_LEN        (-0xfe)  /* 254 */
#define NCP_PACKET_NOT_DELIVERABLE      (-0xfe)  /* 254 */
#define NCP_SOCKET_TABLE_FULL           (-0xfe)  /* 254 */
#define NCP_SPOOL_DIR_ERROR             (-0xfe)  /* 254 */
#define NCP_LOGIN_DISABLED_BY_SUPER     (-0xfe)  /* 254 */
#define NCP_TIMEOUT_FAILURE             (-0xfe)  /* 254 */
#define NCP_FILE_EXISTS                 (-0xff)  /* 255 */
#define NCP_FILE_NAME                   (-0xff)  /* 255 */
#define NCP_HARD_FAILURE                (-0xff)  /* 255 */
#define NCP_IO_BOUND                    (-0xff)  /* 255 */
#define NCP_MUST_FORCE_DOWN             (-0xff)  /* 255 */
#define NCP_NO_SPOOL_FILE               (-0xff)  /* 255 */
#define NCP_NO_TRUSTEE_CHANGE_PRIV      (-0xff)  /* 255 */
#define NCP_TARGET_NOT_ACCEPTING_MSGS   (-0xff)  /* 255 */
#define NCP_TARGET_NOT_LOGGED_IN        (-0xff)  /* 255 */
#define NCP_NO_FILES_FOUND              (-0xff)  /* 255 */
#define NCP_BAD_SPOOL_PRINTER           (-0xff)  /* 255 */
#define NCP_BAD_RECORD_OFFSET           (-0xff)  /* 255 */
#define NCP_DRIVE_INVALID_NUM           (-0xff)  /* 255 */
#define NCP_SEM_INVALID_INIT_VAL        (-0xff)  /* 255 */
#define NCP_SEM_INVALID_HANDLE          (-0xff)  /* 255 */
#define NCP_NO_RESPONSE_FROM_SERVER     (-0xff)  /* 255 */
#define NCP_NO_OBJ_OR_BAD_PASSWORD      (-0xff)  /* 255 */
#define NCP_PATH_NOT_LOCATABLE          (-0xff)  /* 255 */
#define NCP_Q_FULL_ERROR                (-0xff)  /* 255 */
#define NCP_REQ_NOT_OUTSTANDING         (-0xff)  /* 255 */
#define NCP_SOCKET_ALREADY_OPEN         (-0xff)  /* 255 */
#define NCP_LOCK_ERROR                  (-0xff)  /* 255 */


/* +------------------------------------------------------------------------+
   |                                                                        |
   |   NDS errors.                                                          |
   |                                                                        |
   +------------------------------------------------------------------------+ */

/* -1 to -255 are the same as NCP errors */

/* -301 to -399 are returned by the directory services client library */
#define NDS_NOT_ENOUGH_MEMORY          -301     /* 0xfffffed3 */
#define NDS_BAD_KEY                    -302     /* 0xfffffed2 */
#define NDS_BAD_CONTEXT                -303     /* 0xfffffed1 */
#define NDS_BUFFER_FULL                -304     /* 0xfffffed0 */
#define NDS_LIST_EMPTY                 -305     /* 0xfffffecf */
#define NDS_BAD_SYNTAX                 -306     /* 0xfffffece */
#define NDS_BUFFER_EMPTY               -307     /* 0xfffffecd */
#define NDS_BAD_VERB                   -308     /* 0xfffffecc */
#define NDS_EXPECTED_IDENTIFIER        -309     /* 0xfffffecb */
#define NDS_EXPECTED_EQUALS            -310     /* 0xfffffeca */
#define NDS_ATTR_TYPE_EXPECTED         -311     /* 0xfffffec9 */
#define NDS_ATTR_TYPE_NOT_EXPECTED     -312     /* 0xfffffec8 */
#define NDS_FILTER_TREE_EMPTY          -313     /* 0xfffffec7 */
#define NDS_INVALID_OBJECT_NAME        -314     /* 0xfffffec6 */
#define NDS_EXPECTED_RDN_DELIMITER     -315     /* 0xfffffec5 */
#define NDS_TOO_MANY_TOKENS            -316     /* 0xfffffec4 */
#define NDS_INCONSISTENT_MULTIAVA      -317     /* 0xfffffec3 */
#define NDS_COUNTRY_NAME_TOO_LONG      -318     /* 0xfffffec2 */
#define NDS_SYSTEM_ERROR               -319     /* 0xfffffec1 */
#define NDS_CANT_ADD_ROOT              -320     /* 0xfffffec0 */
#define NDS_UNABLE_TO_ATTACH           -321     /* 0xfffffebf */
#define NDS_INVALID_HANDLE             -322     /* 0xfffffebe */
#define NDS_BUFFER_ZERO_LENGTH         -323     /* 0xfffffebd */
#define NDS_INVALID_REPLICA_TYPE       -324     /* 0xfffffebc */
#define NDS_INVALID_ATTR_SYNTAX        -325     /* 0xfffffebb */
#define NDS_INVALID_FILTER_SYNTAX      -326     /* 0xfffffeba */
#define NDS_CONTEXT_CREATION           -328     /* 0xfffffeb8 */
#define NDS_INVALID_UNION_TAG          -329     /* 0xfffffeb7 */
#define NDS_INVALID_SERVER_RESPONSE    -330     /* 0xfffffeb6 */
#define NDS_NULL_POINTER               -331     /* 0xfffffeb5 */
#define NDS_NO_SERVER_FOUND            -332     /* 0xfffffeb4 */
#define NDS_NO_CONNECTION              -333     /* 0xfffffeb3 */
#define NDS_RDN_TOO_LONG               -334     /* 0xfffffeb2 */
#define NDS_DUPLICATE_TYPE             -335     /* 0xfffffeb1 */
#define NDS_DATA_STORE_FAILURE         -336     /* 0xfffffeb0 */
#define NDS_NOT_LOGGED_IN              -337     /* 0xfffffeaf */
#define NDS_INVALID_PASSWORD_CHARS     -338     /* 0xfffffeae */
#define NDS_FAILED_SERVER_AUTHENT      -339     /* 0xfffffead */
#define NDS_TRANSPORT                  -340     /* 0xfffffeac */
#define NDS_NO_SUCH_SYNTAX             -341     /* 0xfffffeab */
#define NDS_INVALID_DS_NAME            -342     /* 0xfffffeaa */
#define NDS_ATTR_NAME_TOO_LONG         -343     /* 0xfffffea9 */
#define NDS_INVALID_TDS                -344     /* 0xfffffea8 */
#define NDS_INVALID_DS_VERSION         -345     /* 0xfffffea7 */
#define NDS_UNICODE_TRANSLATION        -346     /* 0xfffffea6 */
#define NDS_SCHEMA_NAME_TOO_LONG       -347     /* 0xfffffea5 */
#define NDS_UNICODE_FILE_NOT_FOUND     -348     /* 0xfffffea4 */
#define NDS_UNICODE_ALREADY_LOADED     -349     /* 0xfffffea3 */
#define NDS_NOT_CONTEXT_OWNER          -350     /* 0xfffffea2 */
#define NDS_ATTEMPT_TO_AUTHENTICATE_0  -351     /* 0xfffffea1 */
#define NDS_NO_WRITABLE_REPLICAS       -352     /* 0xfffffea0 */
#define NDS_DN_TOO_LONG                -353     /* 0xfffffe9f */
#define NDS_RENAME_NOT_ALLOWED         -354     /* 0xfffffe9e */

/* -601 to -699 are returned by the directory services agent in the server */
#define NDS_NO_SUCH_ENTRY              -601     /* 0xfffffda7 */
#define NDS_NO_SUCH_VALUE              -602     /* 0xfffffda6 */
#define NDS_NO_SUCH_ATTRIBUTE          -603     /* 0xfffffda5 */
#define NDS_NO_SUCH_CLASS              -604     /* 0xfffffda4 */
#define NDS_NO_SUCH_PARTITION          -605     /* 0xfffffda3 */
#define NDS_ENTRY_ALREADY_EXISTS       -606     /* 0xfffffda2 */
#define NDS_NOT_EFFECTIVE_CLASS        -607     /* 0xfffffda1 */
#define NDS_ILLEGAL_ATTRIBUTE          -608     /* 0xfffffda0 */
#define NDS_MISSING_MANDATORY          -609     /* 0xfffffd9f */
#define NDS_ILLEGAL_DS_NAME            -610     /* 0xfffffd9e */
#define NDS_ILLEGAL_CONTAINMENT        -611     /* 0xfffffd9d */
#define NDS_CANT_HAVE_MULTIPLE_VALUES  -612     /* 0xfffffd9c */
#define NDS_SYNTAX_VIOLATION           -613     /* 0xfffffd9b */
#define NDS_DUPLICATE_VALUE            -614     /* 0xfffffd9a */
#define NDS_ATTRIBUTE_ALREADY_EXISTS   -615     /* 0xfffffd99 */
#define NDS_MAXIMUM_ENTRIES_EXIST      -616     /* 0xfffffd98 */
#define NDS_DATABASE_FORMAT            -617     /* 0xfffffd97 */
#define NDS_INCONSISTENT_DATABASE      -618     /* 0xfffffd96 */
#define NDS_INVALID_COMPARISON         -619     /* 0xfffffd95 */
#define NDS_COMPARISON_FAILED          -620     /* 0xfffffd94 */
#define NDS_TRANSACTIONS_DISABLED      -621     /* 0xfffffd93 */
#define NDS_INVALID_TRANSPORT          -622     /* 0xfffffd92 */
#define NDS_SYNTAX_INVALID_IN_NAME     -623     /* 0xfffffd91 */
#define NDS_REPLICA_ALREADY_EXISTS     -624     /* 0xfffffd90 */
#define NDS_TRANSPORT_FAILURE          -625     /* 0xfffffd8f */
#define NDS_ALL_REFERRALS_FAILED       -626     /* 0xfffffd8e */
#define NDS_CANT_REMOVE_NAMING_VALUE   -627     /* 0xfffffd8d */
#define NDS_OBJECT_CLASS_VIOLATION     -628     /* 0xfffffd8c */
#define NDS_ENTRY_IS_NOT_LEAF          -629     /* 0xfffffd8b */
#define NDS_DIFFERENT_TREE             -630     /* 0xfffffd8a */
#define NDS_ILLEGAL_REPLICA_TYPE       -631     /* 0xfffffd89 */
#define NDS_SYSTEM_FAILURE             -632     /* 0xfffffd88 */
#define NDS_INVALID_ENTRY_FOR_ROOT     -633     /* 0xfffffd87 */
#define NDS_NO_REFERRALS               -634     /* 0xfffffd86 */
#define NDS_REMOTE_FAILURE             -635     /* 0xfffffd85 */
#define NDS_UNREACHABLE_SERVER         -636     /* 0xfffffd84 */
#define NDS_PREVIOUS_MOVE_IN_PROGRESS  -637     /* 0xfffffd83 */
#define NDS_NO_CHARACTER_MAPPING       -638     /* 0xfffffd82 */
#define NDS_INCOMPLETE_AUTHENTICATION  -639     /* 0xfffffd81 */
#define NDS_INVALID_CERTIFICATE        -640     /* 0xfffffd80 */
#define NDS_INVALID_REQUEST            -641     /* 0xfffffd7f */
#define NDS_INVALID_ITERATION          -642     /* 0xfffffd7e */
#define NDS_SCHEMA_IS_NONREMOVABLE     -643     /* 0xfffffd7d */
#define NDS_SCHEMA_IS_IN_USE           -644     /* 0xfffffd7c */
#define NDS_CLASS_ALREADY_EXISTS       -645     /* 0xfffffd7b */
#define NDS_BAD_NAMING_ATTRIBUTES      -646     /* 0xfffffd7a */
#define NDS_NOT_ROOT_PARTITION         -647     /* 0xfffffd79 */
#define NDS_INSUFFICIENT_STACK         -648     /* 0xfffffd78 */
#define NDS_INSUFFICIENT_BUFFER        -649     /* 0xfffffd77 */
#define NDS_AMBIGUOUS_CONTAINMENT      -650     /* 0xfffffd76 */
#define NDS_AMBIGUOUS_NAMING           -651     /* 0xfffffd75 */
#define NDS_DUPLICATE_MANDATORY        -652     /* 0xfffffd74 */
#define NDS_DUPLICATE_OPTIONAL         -653     /* 0xfffffd73 */
#define NDS_PARTITION_BUSY             -654     /* 0xfffffd72 */
#define NDS_MULTIPLE_REPLICAS          -655     /* 0xfffffd71 */
#define NDS_CRUCIAL_REPLICA            -656     /* 0xfffffd70 */
#define NDS_SCHEMA_SYNC_IN_PROGRESS    -657     /* 0xfffffd6f */
#define NDS_SKULK_IN_PROGRESS          -658     /* 0xfffffd6e */
#define NDS_TIME_NOT_SYNCHRONIZED      -659     /* 0xfffffd6d */
#define NDS_RECORD_IN_USE              -660     /* 0xfffffd6c */
#define NDS_DS_VOLUME_NOT_MOUNTED      -661     /* 0xfffffd6b */
#define NDS_DS_VOLUME_IO_FAILURE       -662     /* 0xfffffd6a */
#define NDS_DS_LOCKED                  -663     /* 0xfffffd69 */
#define NDS_OLD_EPOCH                  -664     /* 0xfffffd68 */
#define NDS_NEW_EPOCH                  -665     /* 0xfffffd67 */
#define NDS_INCOMPATIBLE_DS_VERSION    -666     /* 0xfffffd66 */
#define NDS_PARTITION_ROOT             -667     /* 0xfffffd65 */
#define NDS_ENTRY_NOT_CONTAINER        -668     /* 0xfffffd64 */
#define NDS_FAILED_AUTHENTICATION      -669     /* 0xfffffd63 */
#define NDS_INVALID_CONTEXT            -670     /* 0xfffffd62 */
#define NDS_NO_SUCH_PARENT             -671     /* 0xfffffd61 */
#define NDS_NO_ACCESS                  -672     /* 0xfffffd60 */
#define NDS_REPLICA_NOT_ON             -673     /* 0xfffffd5f */
#define NDS_INVALID_NAME_SERVICE       -674     /* 0xfffffd5e */
#define NDS_INVALID_TASK               -675     /* 0xfffffd5d */
#define NDS_INVALID_CONN_HANDLE        -676     /* 0xfffffd5c */
#define NDS_INVALID_IDENTITY           -677     /* 0xfffffd5b */
#define NDS_DUPLICATE_ACL              -678     /* 0xfffffd5a */
#define NDS_PARTITION_ALREADY_EXISTS   -679     /* 0xfffffd59 */
#define NDS_TRANSPORT_MODIFIED         -680     /* 0xfffffd58 */
#define NDS_ALIAS_OF_AN_ALIAS          -681     /* 0xfffffd57 */
#define NDS_AUDITING_FAILED            -682     /* 0xfffffd56 */
#define NDS_INVALID_API_VERSION        -683     /* 0xfffffd55 */
#define NDS_SECURE_NCP_VIOLATION       -684     /* 0xfffffd54 */
#define NDS_MOVE_IN_PROGRESS           -685     /* 0xfffffd53 */
#define NDS_NOT_LEAF_PARTITION         -686     /* 0xfffffd52 */
#define NDS_CANNOT_ABORT               -687     /* 0xfffffd51 */
#define NDS_CACHE_OVERFLOW             -688     /* 0xfffffd50 */
#define NDS_INVALID_SUBORDINATE_COUNT  -689     /* 0xfffffd4f */
#define NDS_INVALID_RDN                -690     /* 0xfffffd4e */
#define NDS_MOD_TIME_NOT_CURRENT       -691     /* 0xfffffd4d */
#define NDS_INCORRECT_BASE_CLASS       -692     /* 0xfffffd4c */
#define NDS_MISSING_REFERENCE          -693     /* 0xfffffd4b */
#define NDS_LOST_ENTRY                 -694     /* 0xfffffd4a */
#define NDS_AGENT_ALREADY_REGISTERED   -695     /* 0xfffffd49 */
#define NDS_DS_LOADER_BUSY             -696     /* 0xfffffd48 */
#define NDS_DS_CANNOT_RELOAD           -697     /* 0xfffffd47 */
#define NDS_REPLICA_IN_SKULK           -698     /* 0xfffffd46 */
#define NDS_FATAL                      -699     /* 0xfffffd45 */
#define NDS_OBSOLETE_API               -700     /* 0xfffffd44 */
#define NDS_SYNCHRONIZATION_DISABLED   -701     /* 0xfffffd43 */
#define NDS_INVALID_PARAMETER          -702     /* 0xfffffd42 */
#define NDS_DUPLICATE_TEMPLATE         -703     /* 0xfffffd41 */
#define NDS_NO_MASTER_REPLICA          -704     /* 0xfffffd40 */
#define NDS_DUPLICATE_CONTAINMENT      -705     /* 0xfffffd3f */
#define NDS_NOT_SIBLING                -706     /* 0xfffffd3e */ 
#define NDS_INVALID_SIGNATURE          -707     /* 0xfffffd3d */ 
#define NDS_INVALID_RESPONSE           -708     /* 0xfffffd3c */ 
#define NDS_INSUFFICIENT_SOCKETS       -709     /* 0xfffffd3b */ 
#define NDS_DATABASE_READ_FAIL         -710     /* 0xfffffd3a */ 
#define NDS_INVALID_CODE_PAGE          -711     /* 0xfffffd39 */ 
#define NDS_INVALID_ESCAPE_CHAR        -712     /* 0xfffffd38 */ 
#define NDS_INVALID_DELIMITERS         -713     /* 0xfffffd37 */ 
#define NDS_NOT_IMPLEMENTED            -714     /* 0xfffffd36 */ 
#define NDS_CHECKSUM_FAILURE           -715     /* 0xfffffd35 */ 
#define NDS_CHECKSUMMING_NOT_SUPPORTED -716     /* 0xfffffd34 */ 
#define NDS_CRC_FAILURE                -717     /* 0xfffffd33 */ 
#endif

/* ----- EOF ----- */

