; ͻ
;                                                                      
;    MACROS.I                                                          
;                                                                      
;    Useful ARM macros.                                                
;                                                                      
;    Copyright 1998, Frank A. Vorstenbosch                             
;                                                                      
; ͼ

; Ŀ
;                                                                      
;    Non-dotted pseudo-ops.                                            
;                                                                      
; 

                .define code,.text
                .define data,.data
                .define bss,.bss
                .define public,.globl
                .define extern,.globl
                .define align,.align


; Ŀ
;                                                                      
;    ARM processor definitions.                                        
;                                                                      
; 

N_BIT           = 1<<31
Z_BIT           = 1<<30
C_BIT           = 1<<29
V_BIT           = 1<<28
I_BIT           = 1<<27
F_BIT           = 1<<26

USR_MODE        = 0
FIQ_MODE        = 1
IRQ_MODE        = 2
SVC_MODE        = 3

; Compare instructions:
;
; Unsigned:   >hi  >=hs  <lo  <=ls
; Signed:     >gt  >=ge  <lt  <=le

; Ŀ
;                                                                      
;    Instruction set extension macros.                                 
;                                                                      
; 

;  push and pop 

                .macro  _push,a,b,c,d,e,f,g,h,i,j
__push	.set	0
                .irep   r,\&a,\&b,\&c,\&d,\&e,\&f,\&g,\&h,\&i,\&j
                .ifeqs  "\&r",""
                .exitm
                .else
__pusha	.set	0
                .ifeqs  "\&r","r0"
__pusha	.set	__pusha | (1<<0)
                .endif
                .ifeqs  "\&r","r1"
__pusha	.set	__pusha | (1<<1)
                .endif
                .ifeqs  "\&r","r2"
__pusha	.set	__pusha | (1<<2)
                .endif
                .ifeqs  "\&r","r3"
__pusha	.set	__pusha | (1<<3)
                .endif
                .ifeqs  "\&r","r4"
__pusha	.set	__pusha | (1<<4)
                .endif
                .ifeqs  "\&r","r5"
__pusha	.set	__pusha | (1<<5)
                .endif
                .ifeqs  "\&r","r6"
__pusha	.set	__pusha | (1<<6)
                .endif
                .ifeqs  "\&r","r7"
__pusha	.set	__pusha | (1<<7)
                .endif
                .ifeqs  "\&r","r8"
__pusha	.set	__pusha | (1<<8)
                .endif
                .ifeqs  "\&r","r9"
__pusha	.set	__pusha | (1<<9)
                .endif
                .ifeqs  "\&r","r10"
__pusha	.set	__pusha | (1<<10)
                .endif
                .ifeqs  "\&r","r11"
__pusha	.set	__pusha | (1<<11)
                .endif
                .ifeqs  "\&r","r12"
__pusha	.set	__pusha | (1<<12)
                .endif
                .ifeqs  "\&r","r13"
__pusha	.set	__pusha | (1<<13)
                .endif
                .ifeqs  "\&r","r14"
__pusha	.set	__pusha | (1<<14)
                .endif
                .ifeqs  "\&r","r15"
__pusha	.set	__pusha | (1<<15)
                .endif
                .ifeqs  "\&r","pc"
__pusha	.set	__pusha | (1<<15)
                .endif
	.ifeqs	"\&r","r0-r1"
__pusha	.set	__pusha|0x3
	.endif
	.ifeqs	"\&r","r0-r2"
__pusha	.set	__pusha|0x7
	.endif
	.ifeqs	"\&r","r0-r3"
__pusha	.set	__pusha|0xf
	.endif
	.ifeqs	"\&r","r0-r4"
__pusha	.set	__pusha|0x1f
	.endif
	.ifeqs	"\&r","r0-r5"
__pusha	.set	__pusha|0x3f
	.endif
	.ifeqs	"\&r","r0-r6"
__pusha	.set	__pusha|0x7f
	.endif
	.ifeqs	"\&r","r0-r7"
__pusha	.set	__pusha|0xff
	.endif
	.ifeqs	"\&r","r0-r8"
__pusha	.set	__pusha|0x1ff
	.endif
	.ifeqs	"\&r","r0-r9"
__pusha	.set	__pusha|0x3ff
	.endif
	.ifeqs	"\&r","r0-r10"
__pusha	.set	__pusha|0x7ff
	.endif
	.ifeqs	"\&r","r0-r11"
__pusha	.set	__pusha|0xfff
	.endif
	.ifeqs	"\&r","r0-r12"
__pusha	.set	__pusha|0x1fff
	.endif
	.ifeqs	"\&r","r1-r2"
__pusha	.set	__pusha|0x6
	.endif
	.ifeqs	"\&r","r1-r3"
__pusha	.set	__pusha|0xe
	.endif
	.ifeqs	"\&r","r1-r4"
__pusha	.set	__pusha|0x1e
	.endif
	.ifeqs	"\&r","r1-r5"
__pusha	.set	__pusha|0x3e
	.endif
	.ifeqs	"\&r","r1-r6"
__pusha	.set	__pusha|0x7e
	.endif
	.ifeqs	"\&r","r1-r7"
__pusha	.set	__pusha|0xfe
	.endif
	.ifeqs	"\&r","r1-r8"
__pusha	.set	__pusha|0x1fe
	.endif
	.ifeqs	"\&r","r1-r9"
__pusha	.set	__pusha|0x3fe
	.endif
	.ifeqs	"\&r","r1-r10"
__pusha	.set	__pusha|0x7fe
	.endif
	.ifeqs	"\&r","r1-r11"
__pusha	.set	__pusha|0xffe
	.endif
	.ifeqs	"\&r","r1-r12"
__pusha	.set	__pusha|0x1ffe
	.endif
	.ifeqs	"\&r","r2-r3"
__pusha	.set	__pusha|0xc
	.endif
	.ifeqs	"\&r","r2-r4"
__pusha	.set	__pusha|0x1c
	.endif
	.ifeqs	"\&r","r2-r5"
__pusha	.set	__pusha|0x3c
	.endif
	.ifeqs	"\&r","r2-r6"
__pusha	.set	__pusha|0x7c
	.endif
	.ifeqs	"\&r","r2-r7"
__pusha	.set	__pusha|0xfc
	.endif
	.ifeqs	"\&r","r2-r8"
__pusha	.set	__pusha|0x1fc
	.endif
	.ifeqs	"\&r","r2-r9"
__pusha	.set	__pusha|0x3fc
	.endif
	.ifeqs	"\&r","r2-r10"
__pusha	.set	__pusha|0x7fc
	.endif
	.ifeqs	"\&r","r2-r11"
__pusha	.set	__pusha|0xffc
	.endif
	.ifeqs	"\&r","r2-r12"
__pusha	.set	__pusha|0x1ffc
	.endif
	.ifeqs	"\&r","r3-r4"
__pusha	.set	__pusha|0x18
	.endif
	.ifeqs	"\&r","r3-r5"
__pusha	.set	__pusha|0x38
	.endif
	.ifeqs	"\&r","r3-r6"
__pusha	.set	__pusha|0x78
	.endif
	.ifeqs	"\&r","r3-r7"
__pusha	.set	__pusha|0xf8
	.endif
	.ifeqs	"\&r","r3-r8"
__pusha	.set	__pusha|0x1f8
	.endif
	.ifeqs	"\&r","r3-r9"
__pusha	.set	__pusha|0x3f8
	.endif
	.ifeqs	"\&r","r3-r10"
__pusha	.set	__pusha|0x7f8
	.endif
	.ifeqs	"\&r","r3-r11"
__pusha	.set	__pusha|0xff8
	.endif
	.ifeqs	"\&r","r3-r12"
__pusha	.set	__pusha|0x1ff8
	.endif
	.ifeqs	"\&r","r4-r5"
__pusha	.set	__pusha|0x30
	.endif
	.ifeqs	"\&r","r4-r6"
__pusha	.set	__pusha|0x70
	.endif
	.ifeqs	"\&r","r4-r7"
__pusha	.set	__pusha|0xf0
	.endif
	.ifeqs	"\&r","r4-r8"
__pusha	.set	__pusha|0x1f0
	.endif
	.ifeqs	"\&r","r4-r9"
__pusha	.set	__pusha|0x3f0
	.endif
	.ifeqs	"\&r","r4-r10"
__pusha	.set	__pusha|0x7f0
	.endif
	.ifeqs	"\&r","r4-r11"
__pusha	.set	__pusha|0xff0
	.endif
	.ifeqs	"\&r","r4-r12"
__pusha	.set	__pusha|0x1ff0
	.endif
	.ifeqs	"\&r","r5-r6"
__pusha	.set	__pusha|0x60
	.endif
	.ifeqs	"\&r","r5-r7"
__pusha	.set	__pusha|0xe0
	.endif
	.ifeqs	"\&r","r5-r8"
__pusha	.set	__pusha|0x1e0
	.endif
	.ifeqs	"\&r","r5-r9"
__pusha	.set	__pusha|0x3e0
	.endif
	.ifeqs	"\&r","r5-r10"
__pusha	.set	__pusha|0x7e0
	.endif
	.ifeqs	"\&r","r5-r11"
__pusha	.set	__pusha|0xfe0
	.endif
	.ifeqs	"\&r","r5-r12"
__pusha	.set	__pusha|0x1fe0
	.endif
	.ifeqs	"\&r","r6-r7"
__pusha	.set	__pusha|0xc0
	.endif
	.ifeqs	"\&r","r6-r8"
__pusha	.set	__pusha|0x1c0
	.endif
	.ifeqs	"\&r","r6-r9"
__pusha	.set	__pusha|0x3c0
	.endif
	.ifeqs	"\&r","r6-r10"
__pusha	.set	__pusha|0x7c0
	.endif
	.ifeqs	"\&r","r6-r11"
__pusha	.set	__pusha|0xfc0
	.endif
	.ifeqs	"\&r","r6-r12"
__pusha	.set	__pusha|0x1fc0
	.endif
	.ifeqs	"\&r","r7-r8"
__pusha	.set	__pusha|0x180
	.endif
	.ifeqs	"\&r","r7-r9"
__pusha	.set	__pusha|0x380
	.endif
	.ifeqs	"\&r","r7-r10"
__pusha	.set	__pusha|0x780
	.endif
	.ifeqs	"\&r","r7-r11"
__pusha	.set	__pusha|0xf80
	.endif
	.ifeqs	"\&r","r7-r12"
__pusha	.set	__pusha|0x1f80
	.endif
	.ifeqs	"\&r","r8-r9"
__pusha	.set	__pusha|0x300
	.endif
	.ifeqs	"\&r","r8-r10"
__pusha	.set	__pusha|0x700
	.endif
	.ifeqs	"\&r","r8-r11"
__pusha	.set	__pusha|0xf00
	.endif
	.ifeqs	"\&r","r8-r12"
__pusha	.set	__pusha|0x1f00
	.endif
	.ifeqs	"\&r","r9-r10"
__pusha	.set	__pusha|0x600
	.endif
	.ifeqs	"\&r","r9-r11"
__pusha	.set	__pusha|0xe00
	.endif
	.ifeqs	"\&r","r9-r12"
__pusha	.set	__pusha|0x1e00
	.endif
	.ifeqs	"\&r","r10-r11"
__pusha	.set	__pusha|0xc00
	.endif
	.ifeqs	"\&r","r10-r12"
__pusha	.set	__pusha|0x1c00
	.endif
	.ifeqs	"\&r","r11-r12"
__pusha	.set	__pusha|0x1800
	.endif
                .if     __pusha
__push	.set	__push | __pusha
                .else
                .err    "Invalid parameter \&r to push/pop"
                .endif
                .endif
                .endr
                .endm

                .macro  _cc,c
                .ifeqs  "\&c",""
__cc	.set	0xe0000000
                .exitm
                .endif
                .ifeqs  "\&c","eq"
__cc	.set	0x00000000
                .endif
                .ifeqs  "\&c","ne"
__cc	.set	0x10000000
                .endif
                .ifeqs  "\&c","cs"
__cc	.set	0x20000000
                .endif
                .ifeqs  "\&c","hs"
__cc	.set	0x20000000
                .endif
                .ifeqs  "\&c","cc"
__cc	.set	0x30000000
                .endif
                .ifeqs  "\&c","lo"
__cc	.set	0x30000000
                .endif
                .ifeqs  "\&c","mi"
__cc	.set	0x40000000
                .endif
                .ifeqs  "\&c","pl"
__cc	.set	0x50000000
                .endif
                .ifeqs  "\&c","vs"
__cc	.set	0x60000000
                .endif
                .ifeqs  "\&c","vc"
__cc	.set	0x70000000
                .endif
                .ifeqs  "\&c","hi"
__cc	.set	0x80000000
                .endif
                .ifeqs  "\&c","ls"
__cc	.set	0x90000000
                .endif
                .ifeqs  "\&c","ge"
__cc	.set	0xa0000000
                .endif
                .ifeqs  "\&c","lt"
__cc	.set	0xb0000000
                .endif
                .ifeqs  "\&c","gt"
__cc	.set	0xc0000000
                .endif
                .ifeqs  "\&c","le"
__cc	.set	0xd0000000
                .endif
                .endm

                .macro  push,a,b,c,d,e,f,g,h,z      ; push register list
                .ifnes  "\&z",""
                .err    "Too many paramters to push"
                .endif
                _push   \&a,\&b,\&c,\&d,\&e,\&f,\&g,\&h
                .if     __push==1|__push==2|__push==4|__push==8|__push==16|__push==32|__push==64|__push==128|__push==256|__push==512|__push==1024|__push==2048|__push==4096|__push==16384
                str     \&a,[r13,#-4]!
                .else
                .long   0xe92d0000|__push
                .endif
                .endm

                .macro  pushc,cc,a,b,c,d,e,f,g,h,z  ; conditional push register
                .ifnes  "\&z",""
                .err    "Too many paramters to pushc"
                .endif
                _push   \&a,\&b,\&c,\&d,\&e,\&f,\&g,\&h
                .if     __push==1|__push==2|__push==4|__push==8|__push==16|__push==32|__push==64|__push==128|__push==256|__push==512|__push==1024|__push==2048|__push==4096|__push==16384
                str\&cc \&a,[r13,#-4]!
                .else
                _cc     \&cc
                .long   0x092d0000|__cc|__push
                .endif
                .endm

                .macro  pop,a,b,c,d,e,f,g,h,z       ; pop register list
                .ifnes  "\&z",""
                .err    "Too many paramters to pop"
                .endif
                _push   \&a,\&b,\&c,\&d,\&e,\&f,\&g,\&h
                .if     __push==1|__push==2|__push==4|__push==8|__push==16|__push==32|__push==64|__push==128|__push==256|__push==512|__push==1024|__push==2048|__push==4096|__push==16384
                ldr     \&a,[r13],#4
                .else
                .long   0xe8bd0000|__push
                .endif
                .endm

                .macro  popc,cc,a,b,c,d,e,f,g,h,z   ; conditional pop register
                .ifnes  "\&z",""
                .err    "Too many paramters to popc"
                .endif
                _push   \&a,\&b,\&c,\&d,\&e,\&f,\&g,\&h
                .if     __push==1|__push==2|__push==4|__push==8|__push==16|__push==32|__push==64|__push==128|__push==256|__push==512|__push==1024|__push==2048|__push==4096|__push==16384
                ldr\&cc \&a,[r13],#4
                .else
                _cc     \&cc
                .long   0x08bd0000|__cc|__push
                .endif
                .endm

                .macro  drop,n
                .if     n>0
                add     r13,r13,#n*4
                .else
                add     r13,r13,#4
                .endif
                .endm


;  enter, exit and return 

                .macro  enter,a,b,c,d,e,f,g,h,z     ; enter procedure, save regs
                .ifnes  "\&z",""
                .err    "Too many paramters to enter"
                .endif
                .ifeqs  "\&a",""
                str     r14,[r13,#-4]!
__leave	.set	0
                .else
                _push   \&a,\&b,\&c,\&d,\&e,\&f,\&g,\&h
                .long   0xe92d4000|__push
__leave	.set	__push
                .endif
                .endm

                .macro  exit,cc,z                   ; prepare for exit procedure
                .ifnes  "\&z",""
                .err    "Too many paramters to exit"
                .endif
                .if     __leave==0
                ldr\&cc r14,[r13],#4
                .else
                _cc     \&cc
                .long   0x08bd4000|__cc|__leave
                .endif
                .endm

                .macro  return,cc,z
                .ifnes  "\&z",""
                .err    "Too many paramters to return"
                .endif
                .if     __leave==0
                ldr\&cc pc,[r13],#4
                .else
                _cc     \&cc
                .long   0x08bd8000|__cc|__leave
                .endif
                .endm

                .macro  returns,cc,z
                .ifnes  "\&z",""
                .err    "Too many paramters to returns"
                .endif
                _cc     \&cc
                .long   0x08fd8000|__cc|__leave
                .endm

                .macro  retv,cc                     ; returns with overflow flag set
                orr\&cc\&s pc,r14,#V_BIT
                .endm

                .macro  retvc,cc                    ; returns with overflow flag clear
                bic\&cc\&s pc,r14,#V_BIT
                .endm

                .macro  ret,cc                      ; simple return
                mov\&cc pc,r14
                .endm

                .macro  rets,cc                     ; return with flags restored
                mov\&cc\&s pc,r14
                .endm


;  miscellaneous 

                .macro  clr,r                       ; clear register
                mov     \&r,#0
                .endm

                .macro  clrs,r                      ; clear register and set flags to C=1 N=0 V=0 Z=1
                subs    \&r,\&r,\&r
                .endm

                .macro  dec,r                       ; decrement register
                sub     \&r,\&r,#1
                .endm

                .macro  decs,r                      ; decrement register and set flags
                subs    \&r,\&r,#1
                .endm

                .macro  inc,r                       ; increment register
                add     \&r,\&r,#1
                .endm

                .macro  incs,r                      ; increment register and set flags
                adds    \&r,\&r,#1
                .endm

                .macro  loop,r,label                ; iteration loop
                subs    \&r,\&r,#1
                bne     \&label
                .endm

                .macro  strl,r,loc                  ; store to long address
                adrl    r14,\&loc
                str     \&r,[r14]
                .endm

                .macro  ldrl,r,loc                  ; load from long address
                adrl    r14,\&loc
                ldr     \&r,[r14]
                .endm

                .macro  teqp,r,value
	.ifeqs	"\&r","r0"
                .long   0xe330f000|\&value
                .endif
	.ifeqs	"\&r","r1"
                .long   0xe331f000|\&value
                .endif
	.ifeqs	"\&r","r2"
                .long   0xe332f000|\&value
                .endif
	.ifeqs	"\&r","r3"
                .long   0xe333f000|\&value
                .endif
	.ifeqs	"\&r","r4"
                .long   0xe334f000|\&value
                .endif
	.ifeqs	"\&r","r5"
                .long   0xe335f000|\&value
                .endif
	.ifeqs	"\&r","r6"
                .long   0xe336f000|\&value
                .endif
	.ifeqs	"\&r","r7"
                .long   0xe337f000|\&value
                .endif
	.ifeqs	"\&r","r8"
                .long   0xe338f000|\&value
                .endif
	.ifeqs	"\&r","r9"
                .long   0xe339f000|\&value
                .endif
	.ifeqs	"\&r","r10"
                .long   0xe33af000|\&value
                .endif
	.ifeqs	"\&r","r11"
                .long   0xe33bf000|\&value
                .endif
	.ifeqs	"\&r","r12"
                .long   0xe33cf000|\&value
                .endif
	.ifeqs	"\&r","r13"
                .long   0xe33df000|\&value
                .endif
	.ifeqs	"\&r","r14"
                .long   0xe33ef000|\&value
                .endif
	.ifeqs	"\&r","lr"
                .long   0xe33ef000|\&value
                .endif
	.ifeqs	"\&r","pc"
                .long   0xe33ff000|\&value
                .endif
                .endm


;                MACRO
;$l              bv      $label
;$l              bvs     $label
;                MEND
;
;                MACRO
;$l              bc      $label
;$l              bcs     $label
;                MEND
;
;                MACRO
;$l              bz      $label
;$l              beq     $label
;                MEND
;
;                MACRO
;$l              bm      $label
;$l              bmi     $label
;                MEND
;
;                MACRO
;$l              bnz     $label
;$l              bne     $label
;                MEND
;
;                MACRO
;                public  $a,$b,$c,$d,$e,$f,$g,$h,$z      ; make specified names public
;                ASSERT  "$z"=""
;                IF      :LNOT::DEF:_defined_$a
;                EXPORT  $a
;                TRUE    _defined_$a
;                ENDIF
;                IF "$b"<>""
;                public  $b,$c,$d,$e,$f,$g,$h
;                ENDIF
;                MEND
;
;                MACRO
;                extern  $a,$b,$c,$d,$e,$f,$g,$h,$z      ; import specified names (unless already public)
;                ASSERT  "$z"=""
;                IF      :LNOT::DEF:_imported_$a
;                IF      :LNOT::DEF:_defined_$a
;                IMPORT  $a
;                TRUE    _imported_$a
;                ENDIF
;                ENDIF
;                IF "$b"<>""
;                extern  $b,$c,$d,$e,$f,$g,$h
;                ENDIF
;                MEND
;
;
;;  bitfield definitions 
;
;
;                MACRO
;                _f_sub_ $n,$w
;                IF "$w"<>""
;                IF "$n"<>""
;$n._SHIFT       =     _F_BIT_
;$n._BITS        =     $w
;$n._MASK        =     ((1<<$w)-1)<<_F_BIT_
;                ENDIF
;_F_BIT_         SETA    _F_BIT_+$w
;                ENDIF
;                MEND
;
;                MACRO
;                field   $n9,$w9,$n8,$w8,$n7,$w7,$n6,$w6,$n5,$w5,$n4,$w4,$n3,$w3,$n2,$w2,$n1,$w1,$n0,$w0,$z
;                ASSERT  "$z"=""
;                GBLA    _F_BIT_
;_F_BIT_         SETA    0
;                _f_sub_ $n0,$w0
;                _f_sub_ $n1,$w1
;                _f_sub_ $n2,$w2
;                _f_sub_ $n3,$w3
;                _f_sub_ $n4,$w4
;                _f_sub_ $n5,$w5
;                _f_sub_ $n6,$w6
;                _f_sub_ $n7,$w7
;                _f_sub_ $n8,$w8
;                _f_sub_ $n9,$w9
;                MEND


;  structures 

                .define db,.byte
                .define ds,.block
                .define dw,.2byte
                .define dd,.long

                .macro  struct,name,offset,reg
                .define _STRUCT_NAME_,name
                .seg    name,dummy
                .ifnes  "\&offset",""
                .block  \&offset
                .endif
struct_\&name:
                .ifnes  "\&reg",""
                .using  struct_\&name,\&reg
                .endif
                .undef db
                .undef ds
                .undef dw
                .undef dd
                .purgem db
                .purgem ds
                .purgem dw
                .purgem dd
                .macro  db,elem
elem:           .block  1
                .endm
                .macro  ds,elem,count
elem:           .block  count
                .endm
                .macro  dw,elem
elem:           .block  2
                .endm
                .macro  dd,elem
elem:           .block  4
                .endm
                .endm

                .macro  ends
                .set sizeof_\&_STRUCT_NAME_,.-struct_\&_STRUCT_NAME_
                .previous
                .undef  _STRUCT_NAME_
                .purgem db
                .purgem ds
                .purgem dw
                .purgem dd
                .define ds,.block
                .define db,.byte
                .define dw,.2byte
                .define dd,.long
                .endm


                .macro  DEBUGON
DEBUG           .set 1
                .endm

                .macro  DEBUGOFF
DEBUG           .set 0
                .endm

                .macro version
                .if VERSION>9999
                db      '0'+VERSION/10000
                .endif
                db      '0'+(VERSION/1000)%10
                db      '.'
                db      '0'+(VERSION/100)%10
                db      '0'+(VERSION/10)%10
                .if (VERSION%10)>0
                db      '0'+VERSION%10
                .endif
                .endm


;  ; define utility macros for defining structs
;  
;          .macro  .struct,name            ; macro ".struct" declares a type
;          .define sname,name              ; have to redefine to avoid overriding
;          .macro  sname,sym               ; create a data-definition macro
;  sym:    .block  ..L_\&sname
;          .endm
;          .seg    name,dummy              ; create a dummy section
;  name:
;          .endm
;  
;          .macro  .ends,name              ; macro ".ends" terminates type def
;          .set    ..L_\&name,.-name       ; set struct size
;          .previous                       ; switch back to prev section
;          .endm
;  
;  ; define utility macros for dd,dw,db
;  
;          .macro  dd,name                ; declare a long
;          .align  4
;  name:   .block  4
;          .endm
;  
;          .macro  .dw,name                ; declare a word
;          .align  2
;  name:   .block  2
;          .endm
;  
;          .macro  .db,name                ; declare a byte
;  name:   .block  1
;          .endm
;  
;  ; Ŀ
;  ;                                                                      
;  ;    Example of how to use the structure macros.                       
;  ;                                                                      
;  ; 
;  ;
;  ;; declare some date using the "fred" data_definition macro
;  ;
;  ;.data
;  ;fred    john
;  ;fred    mary
;  ;
;  ;
;  ;; generate code using all of the above
;  ;
;  ;.text
;  ;.using  fred,r8                 ; declare r8 as pointer to fred-type
;  ;ldr     r8,=john                ; init r8 to address of john
;  ;ldr     r0,a                    ; do loads
;  ;ldr     r1,b

;  EOF 
