/* ͻ
                                                                        
      HEAD.H                                                            
                                                                        
      Module library header.                                            
      Automatically generated, do not edit.                             
                                                                        
      Copyright 1999, Frank A. Vorstenbosch                             
                                                                        
   ͼ
*/


#pragma Global_aliasing_convention("_%r")

/*  RiscOS structures  */

struct kernel_error
{  int errorcode;
   char message[1]; 
};

struct Menu;

#ifndef NULL
   #define NULL (void *)0
#endif


/*  inline assembly functions  */

_Asm int ReadCurrentTimeZone(void)
{  
   swi   0x20000|0x43048 ; Territory_ReadCurrentTimeZone
   mov   %r0,%r1
};

/*  */

_Asm int MonotonicTime(void)
{
   swi 0x20000|0x42 ; OS_ReadMonotonicTime
};


/*  allocmem.arm  */

extern struct kernel_error *AllocMem(int bytes,int **pointer);

/*  claim.arm  */

extern void Claim(int vector,void (*handler)(int,int,int),void *data);
extern void Release(int vector,void (*handler)(int,int,int),void *data);

/*  divmod.arm  */

/* Division and Remainder subroutines for C compiler */

/*  free.arm  */

extern void free(void *);

/*  malloc.arm  */

extern void *malloc(int bytes);

/*  memcpy.arm  */

extern void memcpy(void *dest,const void *src,int len);

/*  memset.arm  */

void memset(char *p,int c,int n);

/*  message.arm  */

extern struct kernel_error *MessageTrans_OpenFile(int *messages,const char *name,void *buffer);
extern struct kernel_error *MessageTrans_CloseFile(int *messages);
extern const char *Lookup(int *messages,const char *token);

/*  os1.arm  */

extern struct kernel_error *ParseCommand(const char *keywords,const char *string,void *buffer,int length);

/*  os2.arm  */

extern void ForcePoll(void);

/*  os3.arm  */

extern void ConvertHex2(int value,char *buffer);

/*  os4.arm  */

extern void ConvertHex4(int value,char *buffer);

/*  os5.arm  */

extern void ConvertCardinal2(int value,char *buffer);

/*  os6.arm  */

extern void OSWord(int function,int r1,...);

/*  os7.arm  */

extern int ServiceCall(int r0,int service,...);

/*  os8.arm  */

extern void ConvertHex8(int value,char *buffer);

/*  os9.arm  */

extern struct kernel_error *OSCLI(const char *command);

/*  relocate.arm  */

/* this module contains the relocation subroutine */

/*  ros1.arm  */

extern struct kernel_error *riscos_filesize(const char *name,int *length);

/*  ros2.arm  */

extern int riscos_open(const char *name,int mode);
   /* returns 0 if not opened, or file handle otherwise */
   #define RO_RDONLY  0x40
   #define RO_WRONLY  0xc0
   #define RO_RDWR    0xc0
   #define RO_CREAT   0x80

/*  ros3.arm  */

extern int riscos_seek(int handle,int offset,int whence);
   #define SEEK_SET  0
   #define SEEK_CUR  1
   #define SEEK_END  2

/*  ros4.arm  */

extern int riscos_close(int handle);

/*  ros5.arm  */

extern int riscos_read(int handle,char *buffer,unsigned int length);
extern int riscos_write(int handle,char *buffer,unsigned int length);

/*  ros6.arm  */

extern int riscos_settype(const char *name,int type);
   #define RO_TYPE_OBEY       0xfeb
   #define RO_TYPE_TEMPLATE   0xfec
   #define RO_TYPE_SPRITE     0xff9
   #define RO_TYPE_MODULE     0xffa
   #define RO_TYPE_BASIC      0xffb
   #define RO_TYPE_TEXT       0xfff

/*  ros7.arm  */

extern int riscos_remove(const char *name);

/*  ros8.arm  */

extern void riscos_puts(const char *text);

/*  rvv.arm  */

extern int ReadVarVal(const char *name,void *value,int length,int type);

/*  settime.arm  */

extern void SetROTime(int fivebytetime[2]);

/*  sleep.arm  */

extern void sleep10ms(void);

/*  strcmp.arm  */

extern int strcmp(const char *p,const char *q);

/*  strcpy.arm  */

extern void strcat(char *p,const char *q);
extern void strcpy(char *p,const char *q);

/*  strlen.arm  */

extern int strlen(const char *p);

/*  strlower.arm  */

extern void strlower(char *p);

/*  svv.arm  */

extern void SetVarVal(const char *name,const char *value,int length,int type);

/*  wimp1.arm  */

extern int Wimp_Initialise(int version,int magic,const char *name,int *messages);
#define TASK 0x4b534154
extern struct kernel_error *Wimp_CloseDown(int task,int magic);
extern int Wimp_PollIdle(int mask,int *buffer,int time,int *pollword);

/*  wimp2.arm  */

extern int ReportError(struct kernel_error *err,int flags,char *name);

/*  wimp3.arm  */

extern struct kernel_error *Wimp_LoadTemplate(int *template,int *workspace,int *workend,char *fonts,const char *name,int search,int *r1,int *r2);
extern struct kernel_error *Wimp_OpenTemplate(const char *name);
_Asm struct kernel_error *Wimp_OpenTemplate(const char *name)
{  % reg name
   mov   %r0,name
   swi   0x600d9      ; Wimp_OpenTemplate
   movvc %r0,#0
}
_Asm void Wimp_CloseTemplate(void)
{  swi   0x600da  ; Wimp_CloseTemplate
}

/*  wimp4.arm  */

extern struct kernel_error *Wimp_CreateWindow(int *template,int **window);
extern struct kernel_error *Wimp_CreateIcon(int pri,int *block,int *handle);
extern struct kernel_error *Wimp_DeleteIcon(int *block);
extern struct kernel_error *Wimp_SetIconState(int *block);
extern struct kernel_error *Wimp_GetIconState(int *block);
extern struct kernel_error *Wimp_CreateMenu(struct Menu *menu,int xPos,int yPos);
extern struct kernel_error *Wimp_OpenWindow(int *block);
extern struct kernel_error *Wimp_CloseWindow(int *block);
extern struct kernel_error *Wimp_SetCaretPosition(int *window,int icon,int index);
extern struct kernel_error *Wimp_GetWindowState(int *block);

/*  wimp5.arm  */

extern struct kernel_error *Wimp_SendMessage(int event,int *block,int task,int icon);

